/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.atlassian.http.url.SameOrigin;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import java.io.UnsupportedEncodingException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.regex.Pattern;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.commons.lang3.StringUtils;

public class UrlUtils {
    private static final Pattern REDUNDANT_SLASHES = Pattern.compile("//+");
    private static final Map<String, Integer> DEFAULT_PORTS = ImmutableMap.builder().put((Object)"http", (Object)80).put((Object)"https", (Object)443).build();

    private UrlUtils() {
        throw new UnsupportedOperationException(this.getClass().getName() + " is a utility class and should not be instantiated");
    }

    public static String encodeURL(String fragment) {
        try {
            return URLEncoder.encode(fragment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String decodeURL(String fragment) {
        try {
            return URLDecoder.decode(fragment, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static URI uncheckedCreateURI(@Nullable String uri) {
        if (uri != null) {
            try {
                return new URI(uri);
            }
            catch (URISyntaxException e) {
                throw new IllegalArgumentException(uri + " is not a valid URI.");
            }
        }
        return null;
    }

    public static String concatenate(String base, String ... paths) {
        return StringUtils.stripEnd((String)base, (String)"/") + UrlUtils.removeRedundantSlashes("/" + StringUtils.join((Object[])paths, (String)"/"));
    }

    public static URI concatenate(URI base, String ... paths) throws URISyntaxException {
        return new URI(UrlUtils.concatenate(base.toASCIIString(), paths));
    }

    public static URI uncheckedConcatenate(URI base, URI ... paths) {
        try {
            String[] pathStrings = (String[])Iterables.toArray((Iterable)Lists.transform((List)Lists.newArrayList((Object[])paths), from -> from.toASCIIString()), String.class);
            return UrlUtils.concatenate(base, pathStrings);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to concatenate URIs", e);
        }
    }

    public static URI uncheckedConcatenateAndToUri(String base, String ... paths) {
        return UrlUtils.uncheckedCreateURI(UrlUtils.concatenate(base, paths));
    }

    public static URI uncheckedConcatenate(URI base, String ... paths) {
        try {
            return UrlUtils.concatenate(base, paths);
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException(String.format("Failed to concatenate %s to form URI (%s)", base, e.getReason()), e);
        }
    }

    public static String removeRedundantSlashes(String path) {
        return path == null ? null : REDUNDANT_SLASHES.matcher(path).replaceAll("/");
    }

    public static URI copyOf(URI uri) {
        if (uri == null) {
            return null;
        }
        try {
            return new URI(uri.toASCIIString());
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Failed to copy URI: " + uri.toASCIIString());
        }
    }

    public static URI trimTrailingSlashesFromPath(URI uri) {
        try {
            String urlPath = uri.getPath();
            if (urlPath.endsWith("/")) {
                while (urlPath.endsWith("/")) {
                    urlPath = urlPath.substring(0, urlPath.length() - 1);
                }
                uri = new URI(uri.getScheme(), uri.getUserInfo(), uri.getHost(), uri.getPort(), urlPath, uri.getQuery(), uri.getFragment());
            }
            return uri;
        }
        catch (URISyntaxException e) {
            throw new IllegalArgumentException("Trimming slashes from path of " + uri + " resulted in invalid URI", e);
        }
    }

    public static String replaceBaseUrlWithConfigured(NavBuilder navBuilder, String absoluteUrl) {
        String requestBaseUrl = navBuilder.buildAbsolute();
        String configuredBaseUrl = navBuilder.buildConfigured();
        return configuredBaseUrl + absoluteUrl.substring(requestBaseUrl.length());
    }

    @Nullable
    public static String interpolateUserInfo(@Nullable String url, @Nullable String username) throws URISyntaxException {
        if (url == null) {
            return null;
        }
        if (username == null) {
            return url;
        }
        URI uri = new URI(url);
        return new URI(uri.getScheme(), username, uri.getHost(), uri.getPort(), uri.getPath(), uri.getQuery(), uri.getFragment()).toASCIIString();
    }

    @Nonnull
    public static String buildQueryParams(Object ... params) {
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < params.length; i += 2) {
            Object paramName = params[i];
            Object paramValue = params[i + 1];
            if (paramName == null || paramValue == null) continue;
            sb.append(paramName).append('=').append(UrlUtils.encodeURL(String.valueOf(paramValue)));
            if (i + 2 >= params.length) continue;
            sb.append('&');
        }
        return sb.toString();
    }

    @Nonnull
    public static String buildQueryParamsFromMap(Map<?, List<Object>> params) {
        StringBuilder sb = new StringBuilder();
        boolean separatorNeeded = false;
        for (Map.Entry<?, List<Object>> entry : params.entrySet()) {
            Object paramName = entry.getKey();
            if (paramName == null) continue;
            List<Object> paramList = entry.getValue();
            if (paramList.isEmpty()) {
                sb.append(separatorNeeded ? "&" : "").append(paramName);
                separatorNeeded = true;
            }
            for (Object paramValue : paramList) {
                if (paramValue == null) continue;
                sb.append(separatorNeeded ? "&" : "").append(paramName).append('=').append(UrlUtils.encodeURL(String.valueOf(paramValue)));
                separatorNeeded = true;
            }
        }
        return sb.toString();
    }

    public static String safeUrlForRedirect(String url, String baseUrl, String fallbackUrl) {
        try {
            URI uri = new URI(url);
            if (UrlUtils.isLocalPath(uri)) {
                return url.charAt(0) == '/' ? url : '/' + url;
            }
            URI redirectUri = UrlUtils.getCanonicalUri(uri);
            if (SameOrigin.isSameOrigin((URI)redirectUri, (URI)new URI(baseUrl)) && redirectUri.toString().startsWith(baseUrl)) {
                return url;
            }
        }
        catch (MalformedURLException | URISyntaxException exception) {
            // empty catch block
        }
        return fallbackUrl;
    }

    public static String getCanonicalUrl(String url) {
        URI uri = URI.create(url);
        return UrlUtils.getCanonicalUri(uri).toString();
    }

    public static URI getCanonicalUri(URI uri) {
        StringBuilder builder = new StringBuilder().append(StringUtils.lowerCase((String)uri.getScheme())).append("://").append(uri.getHost());
        if (UrlUtils.hasCustomPort(uri)) {
            builder.append(":").append(uri.getPort());
        }
        builder.append(uri.getPath());
        return URI.create(builder.toString());
    }

    public static String getPathAndQuery(String uri) {
        String path = "/";
        try {
            URI url = new URI(uri);
            String p = url.getPath();
            String q = url.getQuery();
            if (p.length() > 0) {
                path = p;
            }
            if (!path.startsWith("/") && path.contains("/")) {
                path = path.substring(path.indexOf(47));
            }
            if (p.length() > 0 && q != null && q.length() > 0) {
                path = path + "?" + q;
            }
            if (!(url.isAbsolute() || p.length() != 0 || q != null && q.length() != 0)) {
                path = uri;
            }
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return path;
    }

    @VisibleForTesting
    protected static boolean isLocalPath(URI uri) {
        return StringUtils.isNotEmpty((CharSequence)uri.getPath()) && uri.getAuthority() == null && uri.getHost() == null && uri.getPort() == -1 && uri.getScheme() == null;
    }

    private static boolean hasCustomPort(URI uri) {
        if (uri.getPort() < 0) {
            return false;
        }
        Integer defaultPort = DEFAULT_PORTS.get(StringUtils.lowerCase((String)uri.getScheme(), (Locale)Locale.ROOT));
        return defaultPort == null || defaultPort.intValue() != uri.getPort();
    }
}

