/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.util;

import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageProvider;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import java.util.Iterator;

public class PagedIterable<T>
implements Iterable<T> {
    private final PageProvider<T> pageProvider;
    private final PageRequest pageRequest;

    public PagedIterable(PageProvider<T> pageProvider, int pageSize) {
        this(pageProvider, PageUtils.newRequest(0, pageSize));
    }

    public PagedIterable(PageProvider<T> pageProvider, PageRequest pageRequest) {
        this.pageProvider = pageProvider;
        this.pageRequest = pageRequest;
    }

    @Override
    public Iterator<T> iterator() {
        return new PagedIterator(this.pageProvider.get(this.pageRequest));
    }

    private class PagedIterator
    implements Iterator<T> {
        private Page<T> currentPage;
        private Iterator<T> iterator;

        PagedIterator(Page<T> page) {
            this.currentPage = page;
            this.iterator = page.getValues().iterator();
        }

        @Override
        public boolean hasNext() {
            while (!this.iterator.hasNext()) {
                if (this.currentPage.getIsLastPage()) {
                    return false;
                }
                this.currentPage = PagedIterable.this.pageProvider.get(this.currentPage.getNextPageRequest());
                this.iterator = this.currentPage.getValues().iterator();
            }
            return true;
        }

        @Override
        public T next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

