/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.smtp;

import com.atlassian.bitbucket.async.AsyncTestUtils;
import com.atlassian.bitbucket.async.WaitCondition;
import com.atlassian.bitbucket.smtp.EmailCapturingWaitCondition;
import com.atlassian.bitbucket.smtp.MailTestUtils;
import com.atlassian.bitbucket.smtp.SmtpServer;
import com.icegreen.greenmail.util.GreenMail;
import com.icegreen.greenmail.util.ServerSetup;
import java.net.BindException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.util.Arrays;
import java.util.List;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;

public class GreenMailSmtpServer
implements SmtpServer {
    private static final int TCP_TIMEWAIT_LEN = 60000;
    private final GreenMail greenMailServer;
    private int smtpPort;

    public GreenMailSmtpServer(int smtpPort) {
        this.smtpPort = smtpPort;
        ServerSetup config = new ServerSetup(smtpPort, null, "smtp");
        config.setServerStartupTimeout(10000L);
        this.greenMailServer = new GreenMail(config);
    }

    @Override
    public int getPort() {
        return this.smtpPort;
    }

    @Override
    public void start() {
        this.greenMailServer.start();
    }

    @Override
    public void stop() {
        this.greenMailServer.stop();
        AsyncTestUtils.waitFor(new WaitCondition(){

            @Override
            public boolean test() throws Exception {
                try {
                    ServerSocket serverSocket = new ServerSocket();
                    serverSocket.bind(new InetSocketAddress("127.0.0.1", GreenMailSmtpServer.this.getPort()));
                    serverSocket.close();
                    return true;
                }
                catch (BindException e) {
                    return false;
                }
            }

            @Override
            public void describeFailure(Description description) throws Exception {
                description.appendText("Stopping the greenmail server did not free the port that it started on.");
            }
        }, 120001L, 1000L);
    }

    @Override
    public MimeMessage waitForEmail(Matcher<MimeMessage> emailMatcher) {
        return this.waitForEmail(DEFAULT_TIMEOUT_IN_MS, emailMatcher);
    }

    @Override
    public MimeMessage waitForEmail(long timeout, Matcher<MimeMessage> emailMatcher) {
        EmailCapturingWaitCondition emailCapturingWaitCondition = new EmailCapturingWaitCondition(this, emailMatcher);
        AsyncTestUtils.waitFor(emailCapturingWaitCondition, timeout);
        return emailCapturingWaitCondition.getMatchingEmail();
    }

    @Override
    public void waitForReceivedEmails(int emailCount) {
        this.waitForReceivedEmails(DEFAULT_TIMEOUT_IN_MS, emailCount);
    }

    @Override
    public void waitForReceivedEmails(long timeout, int emailCount) {
        if (!this.greenMailServer.waitForIncomingEmail(timeout, emailCount)) {
            throw new AssertionError((Object)this.createReceivedEmailSummary("Did not receive " + emailCount + " emails before timeout"));
        }
    }

    @Override
    public List<MimeMessage> getReceivedEmails() {
        return Arrays.asList(this.greenMailServer.getReceivedMessages());
    }

    private String createReceivedEmailSummary(String message) {
        String receivedEmailString;
        StringBuilder sb = new StringBuilder();
        sb.append(message).append("\n");
        sb.append("Received emails:");
        try {
            receivedEmailString = MailTestUtils.asFormattedString(this.getReceivedEmails());
        }
        catch (MessagingException e) {
            receivedEmailString = "Error generating email summary";
        }
        sb.append(receivedEmailString);
        return sb.toString();
    }
}

