/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mockito;

import com.atlassian.bitbucket.mockito.MockitoUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.base.Preconditions;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PagesAnswer<T>
implements Answer<Page<T>> {
    private final int elementCount;
    private final Function<Integer, T> generator;

    private PagesAnswer(int elementCount, Function<Integer, T> generator) {
        this.elementCount = elementCount;
        this.generator = this.restrictedElementGenerator(Objects.requireNonNull(generator, "generator"));
    }

    @Nonnull
    public static <T> PagesAnswer<T> withPagesUpTo(int maxElementCount, @Nonnull Function<Integer, T> generator) {
        Preconditions.checkArgument((maxElementCount > 0 ? 1 : 0) != 0, (Object)"maxElementCount must be >0");
        return new PagesAnswer<T>(maxElementCount, generator);
    }

    @Nonnull
    public Page<T> answer(@Nonnull InvocationOnMock invocation) throws Throwable {
        PageRequest request = MockitoUtils.findPageRequest(invocation);
        return PageUtils.createPage((PageRequest)request, this.generator);
    }

    private Function<Integer, T> restrictedElementGenerator(Function<Integer, T> original) {
        return i -> {
            if (i >= this.elementCount) {
                return null;
            }
            return original.apply((Integer)i);
        };
    }
}

