/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mockito;

import com.atlassian.bitbucket.mockito.PageAnswer;
import com.atlassian.bitbucket.mockito.SelfAnswer;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.mockito.ArgumentCaptor;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class MockitoUtils {
    public static <T> T getCaptorOfType(Class<T> type, ArgumentCaptor captor) {
        for (Object value : captor.getAllValues()) {
            if (!value.getClass().isAssignableFrom(type)) continue;
            return type.cast(value);
        }
        return null;
    }

    public static <T> List<T> getCaptorsOfType(Class<T> type, ArgumentCaptor captor) {
        ArrayList values = Lists.newArrayList();
        for (Object value : captor.getAllValues()) {
            if (!value.getClass().isAssignableFrom(type)) continue;
            values.add(type.cast(value));
        }
        return values;
    }

    public static <K, V> Answer<Void> putsValueInMap(Map<K, V> map) {
        return MockitoUtils.putsValueInMap(map, 0, 1);
    }

    public static <K, V> Answer<Void> putsValueInMap(Map<K, V> map, int keyIndex, int valueIndex) {
        return invocation -> {
            map.put(invocation.getArgument(keyIndex), invocation.getArgument(valueIndex));
            return null;
        };
    }

    public static <K, V> Answer<Void> removesValueInMap(Map<K, V> map) {
        return MockitoUtils.removesValueInMap(map, 0);
    }

    public static <K, V> Answer<Void> removesValueInMap(Map<K, V> map, int keyIndex) {
        return invocation -> {
            map.remove(invocation.getArgument(keyIndex));
            return null;
        };
    }

    public static <T> Answer<T> returnArg(int index) {
        return invocationOnMock -> invocationOnMock.getArgument(index);
    }

    public static <T> Answer<T> returnFirst() {
        return MockitoUtils.returnArg(0);
    }

    public static SelfAnswer returnSelf(Class<?> mockType) {
        return new SelfAnswer(mockType);
    }

    public static SelfAnswer returnSelf(Class<?> mockType, Answer<Object> defaultAnswer) {
        return new SelfAnswer(mockType, defaultAnswer);
    }

    public static <E> Answer<Page<E>> returnPageOf(@Nonnull Iterable<E> elements) {
        return PageAnswer.withPageOf(elements);
    }

    public static <E> Answer<Page<E>> returnLastPageOf(@Nonnull Iterable<E> elements) {
        return PageAnswer.withLastPageOf(elements);
    }

    public static Answer<Object> returnsSelf() {
        return InvocationOnMock::getMock;
    }

    public static <K, V> Answer<V> returnsValueFromMap(Map<K, V> map) {
        return MockitoUtils.returnsValueFromMap(map, 0);
    }

    public static <K, V> Answer<V> returnsValueFromMap(Map<K, V> map, int keyIndex) {
        return invocation -> map.get(invocation.getArgument(keyIndex));
    }

    public static <T> Answer<T> throwOnce(@Nonnull Throwable t) {
        return MockitoUtils.throwOnce(t, null);
    }

    public static <T> Answer<T> throwOnce(final @Nonnull Throwable t, final @Nullable T result) {
        return new Answer<T>(){
            private boolean threw;

            public T answer(InvocationOnMock invocation) throws Throwable {
                if (this.threw) {
                    return result;
                }
                this.threw = true;
                throw t;
            }
        };
    }

    static PageRequest findPageRequest(InvocationOnMock invocation) {
        for (Object arg : invocation.getArguments()) {
            if (!(arg instanceof PageRequest)) continue;
            return (PageRequest)arg;
        }
        throw new IllegalStateException("This answer must be used only for invocations containing PageRequest, was: " + invocation);
    }
}

