/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.time.Instant;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TimeMatchers {
    @Nonnull
    public static Matcher<Date> closeTo(final @Nonnull Date expected, final int plusOrMinus, final @Nonnull TimeUnit unit) {
        Objects.requireNonNull(expected, "expected");
        Objects.requireNonNull(unit, "unit");
        return new TypeSafeMatcher<Date>(){

            public void describeTo(Description description) {
                description.appendText("a date around ").appendValue((Object)expected).appendText(" plus or minus ").appendValue((Object)plusOrMinus).appendText(" ").appendText(unit.name().toLowerCase(Locale.ROOT));
            }

            public boolean matchesSafely(Date date) {
                return Math.abs(expected.getTime() - date.getTime()) < unit.toMillis(plusOrMinus);
            }
        };
    }

    @Nonnull
    public static Matcher<Instant> closeTo(final @Nonnull Instant expected, final int plusOrMinus, final @Nonnull TimeUnit unit) {
        Objects.requireNonNull(expected, "expected");
        Objects.requireNonNull(unit, "unit");
        return new TypeSafeMatcher<Instant>(){

            protected boolean matchesSafely(Instant instant) {
                return Math.abs(expected.toEpochMilli() - instant.toEpochMilli()) < unit.toMillis(plusOrMinus);
            }

            public void describeTo(Description description) {
                description.appendText("an instant around ").appendValue((Object)expected).appendText(" plus or minus ").appendValue((Object)plusOrMinus).appendText(" ").appendText(unit.name().toLowerCase(Locale.ROOT));
            }
        };
    }

    @Nonnull
    public static Matcher<Date> closeToNow(int plusOrMinus, @Nonnull TimeUnit unit) {
        return TimeMatchers.closeTo(new Date(), plusOrMinus, unit);
    }
}

