/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.util.Page;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class PageMatchers {
    private PageMatchers() {
        throw new UnsupportedOperationException(PageMatchers.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static <T> Matcher<Page<T>> hasSize(int expectedSize) {
        return PageMatchers.hasSizeThat((Matcher<Integer>)Matchers.is((Object)expectedSize));
    }

    @Nonnull
    public static <T> Matcher<Page<T>> hasSizeThat(@Nonnull Matcher<Integer> sizeMatcher) {
        Objects.requireNonNull(sizeMatcher, "sizeMatcher");
        return new FeatureMatcher<Page<T>, Integer>(sizeMatcher, "size that", "size"){

            protected Integer featureValueOf(@Nonnull Page<T> actual) {
                return actual.getSize();
            }
        };
    }

    @Nonnull
    public static <T> Matcher<Page<T>> hasStart(int expectedStart) {
        return PageMatchers.hasStartThat((Matcher<Integer>)Matchers.is((Object)expectedStart));
    }

    @Nonnull
    public static <T> Matcher<Page<T>> hasStartThat(@Nonnull Matcher<Integer> startMatcher) {
        Objects.requireNonNull(startMatcher, "startMatcher");
        return new FeatureMatcher<Page<T>, Integer>(startMatcher, "start that", "start"){

            protected Integer featureValueOf(@Nonnull Page<T> actual) {
                return actual.getStart();
            }
        };
    }

    @Nonnull
    public static <T> Matcher<Page<T>> isEmptyPage() {
        return PageMatchers.hasSize(0);
    }

    @Nonnull
    public static <T> Matcher<Page<T>> isLastPage() {
        return new TypeSafeDiagnosingMatcher<Page<T>>(){

            protected boolean matchesSafely(Page<T> item, Description mismatchDescription) {
                if (!item.getIsLastPage()) {
                    mismatchDescription.appendText("not last");
                }
                return item.getIsLastPage();
            }

            public void describeTo(Description description) {
                description.appendText("Last page with results");
            }
        };
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<T>> isLastPageOf(Matcher<? super T> ... expectedValues) {
        return Matchers.allOf(PageMatchers.isLastPage(), PageMatchers.isPageOf(expectedValues));
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<T>> isLastPageOf(T ... expectedValues) {
        return Matchers.allOf(PageMatchers.isLastPage(), PageMatchers.isPageOf(expectedValues));
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<T>> isPageOf(Matcher<? super T> ... expectedValues) {
        return Matchers.allOf(PageMatchers.hasSize(expectedValues.length), PageMatchers.isPageOf(Matchers.contains(expectedValues)));
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<T>> isPageOf(T ... expectedValues) {
        return Matchers.allOf(PageMatchers.hasSize(expectedValues.length), PageMatchers.isPageOf(Matchers.contains((Object[])expectedValues)));
    }

    @Nonnull
    public static <T> Matcher<Page<T>> isPageOf(@Nonnull Matcher<? super Iterable<T>> valuesMatcher) {
        Objects.requireNonNull(valuesMatcher, "valuesMatcher");
        return new FeatureMatcher<Page<T>, Iterable<T>>(valuesMatcher, "values that", "values"){

            protected Iterable<T> featureValueOf(@Nonnull Page<T> actual) {
                return actual.getValues();
            }
        };
    }

    @Nonnull
    public static <T> Matcher<Page<T>> isPageWithSize(int expectedSize) {
        return PageMatchers.hasSize(expectedSize);
    }
}

