/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.io.IoConsumer;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.charset.StandardCharsets;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.StringDescription;
import org.hamcrest.TypeSafeDiagnosingMatcher;
import org.mockito.ArgumentMatcher;

public class IoConsumerOutputStreamMatcher
extends TypeSafeDiagnosingMatcher<IoConsumer<OutputStream>> {
    private final Matcher<String> expectedContent;

    public IoConsumerOutputStreamMatcher(Matcher<String> expectedContent) {
        this.expectedContent = expectedContent;
    }

    public static ArgumentMatcher<IoConsumer<OutputStream>> hasIoConsumerStreamContent(String expectedContent) {
        return IoConsumerOutputStreamMatcher.hasIoConsumerStreamContent((Matcher<String>)CoreMatchers.equalTo((Object)expectedContent));
    }

    public static ArgumentMatcher<IoConsumer<OutputStream>> hasIoConsumerStreamContent(Matcher<String> expectedContent) {
        final IoConsumerOutputStreamMatcher streamMatcher = new IoConsumerOutputStreamMatcher(expectedContent);
        return new ArgumentMatcher<IoConsumer<OutputStream>>(){

            public boolean matches(IoConsumer<OutputStream> argument) {
                return streamMatcher.matches(argument);
            }

            public String toString() {
                StringDescription description = new StringDescription();
                streamMatcher.describeTo((Description)description);
                return description.toString();
            }
        };
    }

    public void describeTo(Description description) {
        description.appendText("OutputStream written matches ").appendDescriptionOf(this.expectedContent);
    }

    protected boolean matchesSafely(IoConsumer<OutputStream> item, Description mismatchDescription) {
        ByteArrayOutputStream outputBuffer = new ByteArrayOutputStream();
        try {
            item.accept((Object)outputBuffer);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        String actualContent = new String(outputBuffer.toByteArray(), StandardCharsets.UTF_8);
        if (!this.expectedContent.matches((Object)actualContent)) {
            mismatchDescription.appendText(" didn't match: ");
            this.expectedContent.describeMismatch((Object)actualContent, mismatchDescription);
            return false;
        }
        return true;
    }
}

