/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.google.common.base.Preconditions;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.Arrays;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class FileContentsMatcher
extends TypeSafeMatcher<Path> {
    private byte[] actual;
    private final byte[] expected;

    public FileContentsMatcher(@Nonnull Path expected) {
        super(Path.class);
        Preconditions.checkArgument((boolean)Files.isRegularFile(Objects.requireNonNull(expected, "expected"), new LinkOption[0]), (Object)"'expected' must be a file.");
        try {
            this.expected = Files.readAllBytes(expected);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected boolean matchesSafely(Path item) {
        Preconditions.checkArgument((boolean)Files.isRegularFile(item, new LinkOption[0]), (Object)"path must point to a regular file.");
        try {
            this.actual = Files.readAllBytes(item);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return this.matchesFileContent();
    }

    protected void describeMismatchSafely(Path item, Description mismatchDescription) {
        mismatchDescription.appendText("instead got:\n");
        mismatchDescription.appendText(Arrays.toString(this.actual));
    }

    private boolean matchesFileContent() {
        return Arrays.equals(this.actual, this.expected);
    }

    public void describeTo(Description description) {
        description.appendText("file content to be equal to:\n");
        description.appendText(Arrays.toString(this.expected));
    }
}

