/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import net.java.ao.test.jdbc.AbstractJdbcConfiguration;
import net.java.ao.test.jdbc.H2Memory;
import net.java.ao.test.jdbc.JdbcConfiguration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SystemPropertyJdbcConfiguration
implements JdbcConfiguration {
    static final String PROTOCOL_JTDS = "jdbc:jtds:sqlserver";
    static final String PROTOCOL_SQLSERVER = "jdbc:sqlserver";
    private static final Logger log = LoggerFactory.getLogger(SystemPropertyJdbcConfiguration.class);
    private static final String PROP_JDBC_PREFIX = "jdbc.";
    private static final String PROP_JDBC_USER = "jdbc.user";
    private static final String PROP_JDBC_PASSWORD = "jdbc.password";
    private static final String PROP_JDBC_SCHEMA = "jdbc.schema";
    static final String PROP_JDBC_URL = "jdbc.url";
    private final JdbcConfiguration delegate;

    public SystemPropertyJdbcConfiguration() {
        Object url = System.getProperty(PROP_JDBC_URL);
        String user = System.getProperty(PROP_JDBC_USER);
        String password = System.getProperty(PROP_JDBC_PASSWORD);
        String schema = System.getProperty(PROP_JDBC_SCHEMA);
        if (url != null && user != null && password != null) {
            if (((String)url).startsWith(PROTOCOL_JTDS)) {
                String temp = PROTOCOL_SQLSERVER + ((String)url).substring(PROTOCOL_JTDS.length());
                log.warn("Rewrote jTDS JDBC URL to Microsoft equivalent. {} -> {}", url, (Object)temp);
                url = temp;
            }
            if (schema == null && ((String)url).startsWith(PROTOCOL_SQLSERVER)) {
                schema = "dbo";
            }
            this.delegate = new SimpleJdbcConfiguration((String)url, user, password, schema);
            log.info("Using custom database configurations for AO test. url={}, user={}, password={}, schema={}", new Object[]{url, user, password, schema});
        } else {
            H2Memory h2 = new H2Memory();
            this.delegate = new SimpleJdbcConfiguration(h2.getUrl() + ";DB_CLOSE_DELAY=-1;DB_CLOSE_ON_EXIT=TRUE", h2.getUsername(), h2.getPassword(), h2.getSchema());
            log.info("Using in-memory H2 database for AO test");
        }
    }

    public String getPassword() {
        return this.delegate.getPassword();
    }

    public String getSchema() {
        return this.delegate.getSchema();
    }

    public String getUrl() {
        return this.delegate.getUrl();
    }

    public String getUsername() {
        return this.delegate.getUsername();
    }

    public void init() {
        this.delegate.init();
    }

    private static class SimpleJdbcConfiguration
    extends AbstractJdbcConfiguration {
        private SimpleJdbcConfiguration(String url, String user, String password, String schema) {
            super(url, user, password, schema);
        }

        protected String getDefaultSchema() {
            return "";
        }

        protected String getDefaultUrl() {
            return "";
        }
    }
}

