/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket;

import java.time.Duration;
import java.util.function.Supplier;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class EventuallyMatcher<T>
extends TypeSafeMatcher<Supplier<T>> {
    private final Matcher<T> matcher;
    private final Duration retryWait;
    private final Duration timeout;

    private EventuallyMatcher(Matcher<T> matcher, Duration timeout, Duration retryWait) {
        this.matcher = matcher;
        this.timeout = timeout;
        this.retryWait = retryWait;
    }

    public static <T> Matcher<Supplier<T>> eventually(Matcher<T> matcher, Duration timeout, Duration retryWait) {
        return new EventuallyMatcher<T>(matcher, timeout, retryWait);
    }

    public static <T> Matcher<Supplier<T>> eventually(Matcher<T> matcher) {
        return EventuallyMatcher.eventually(matcher, Duration.ofSeconds(10L), Duration.ofMillis(500L));
    }

    public void describeTo(Description description) {
        this.matcher.describeTo(description);
    }

    protected void describeMismatchSafely(Supplier<T> item, Description mismatchDescription) {
        this.matcher.describeMismatch(item.get(), mismatchDescription);
    }

    protected boolean matchesSafely(Supplier<T> item) {
        long iterations = this.timeout.toMillis() / this.retryWait.toMillis();
        int attempts = 0;
        while ((long)attempts++ < iterations) {
            if (this.matcher.matches(item.get())) {
                return true;
            }
            try {
                Thread.sleep(this.retryWait.toMillis());
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw new RuntimeException(e);
            }
        }
        return false;
    }
}

