/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.transaction;

import com.atlassian.bitbucket.transaction.SimpleSalTransactionSynchronisationManager;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.google.common.base.Throwables;
import java.util.Optional;

public class SimpleSalTransactionTemplate
implements TransactionTemplate {
    private static final ThreadLocal<TxInfo> tlsTxInfo = ThreadLocal.withInitial(TxInfo::new);
    private final Optional<SimpleSalTransactionSynchronisationManager> syncManager;

    public SimpleSalTransactionTemplate() {
        this(null);
    }

    public SimpleSalTransactionTemplate(SimpleSalTransactionSynchronisationManager syncManager) {
        this.syncManager = Optional.ofNullable(syncManager);
        this.syncManager.ifPresent(it -> it.setTxTemplate(this));
    }

    public <T> T execute(TransactionCallback<T> action) {
        TxInfo txInfo = tlsTxInfo.get();
        ++txInfo.depth;
        try {
            Object object = action.doInTransaction();
            return (T)object;
        }
        catch (Throwable t) {
            txInfo.markRollback = true;
            throw Throwables.propagate((Throwable)t);
        }
        finally {
            --txInfo.depth;
            if (txInfo.depth == 0) {
                txInfo.markRollback = false;
                if (this.syncManager != null) {
                    if (txInfo.markRollback) {
                        this.syncManager.ifPresent(SimpleSalTransactionSynchronisationManager::onRollback);
                    } else {
                        this.syncManager.ifPresent(SimpleSalTransactionSynchronisationManager::onCommit);
                    }
                    this.syncManager.ifPresent(SimpleSalTransactionSynchronisationManager::clear);
                }
                tlsTxInfo.remove();
            }
        }
    }

    boolean isActive() {
        TxInfo txInfo = tlsTxInfo.get();
        if (txInfo.depth == 0) {
            tlsTxInfo.remove();
            return false;
        }
        return true;
    }

    private static class TxInfo {
        private int depth;
        private boolean markRollback;

        private TxInfo() {
        }
    }
}

