/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.transaction;

import com.atlassian.activeobjects.spi.TransactionSynchronisationManager;
import com.atlassian.bitbucket.transaction.SimpleSalTransactionTemplate;
import com.google.common.collect.Lists;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleSalTransactionSynchronisationManager
implements TransactionSynchronisationManager {
    private static final Logger log = LoggerFactory.getLogger(SimpleSalTransactionSynchronisationManager.class);
    private static final ThreadLocal<TxInfo> tlsTxInfo = ThreadLocal.withInitial(TxInfo::new);
    private SimpleSalTransactionTemplate template;

    public void onRollback() {
        for (Runnable rollbackAction : SimpleSalTransactionSynchronisationManager.tlsTxInfo.get().rollbackActions) {
            try {
                rollbackAction.run();
            }
            catch (Exception e) {
                log.error("Exception during rollback action", (Throwable)e);
            }
        }
    }

    public void onCommit() {
        for (Runnable commitAction : SimpleSalTransactionSynchronisationManager.tlsTxInfo.get().commitActions) {
            try {
                commitAction.run();
            }
            catch (Exception e) {
                log.error("Exception during successful commit acction", (Throwable)e);
            }
        }
    }

    public boolean runOnRollBack(Runnable callback) {
        if (!this.isActiveSynchronisedTransaction()) {
            return false;
        }
        SimpleSalTransactionSynchronisationManager.tlsTxInfo.get().rollbackActions.add(callback);
        return true;
    }

    public boolean runOnSuccessfulCommit(Runnable callback) {
        if (!this.isActiveSynchronisedTransaction()) {
            return false;
        }
        SimpleSalTransactionSynchronisationManager.tlsTxInfo.get().commitActions.add(callback);
        return true;
    }

    public boolean isActiveSynchronisedTransaction() {
        return this.template.isActive();
    }

    void clear() {
        tlsTxInfo.remove();
    }

    void setTxTemplate(SimpleSalTransactionTemplate template) {
        this.template = template;
    }

    private static class TxInfo {
        private List<Runnable> rollbackActions = Lists.newArrayList();
        private List<Runnable> commitActions = Lists.newArrayList();

        private TxInfo() {
        }
    }
}

