/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.stp;

import com.atlassian.support.tools.spi.SupportInfoBuilderContext;
import com.atlassian.support.tools.spi.SupportInfoDetail;
import com.google.common.collect.Maps;
import java.util.Date;
import java.util.Map;
import javax.annotation.Nonnull;

public class SimpleSupportInfoBuilderContext
implements SupportInfoBuilderContext {
    private final SupportInfoDetail detail;
    private final Date start;
    private final Map<String, Object> properties;

    public SimpleSupportInfoBuilderContext(@Nonnull SupportInfoDetail detail) {
        this(detail, new Date());
    }

    public SimpleSupportInfoBuilderContext(@Nonnull SupportInfoDetail detail, @Nonnull Date start) {
        this.detail = detail;
        this.start = start;
        this.properties = Maps.newHashMap();
    }

    public boolean removeProperty(String name) {
        return this.properties.remove(name) != null;
    }

    public SupportInfoDetail getRequestDetail() {
        return this.detail;
    }

    public Date getStart() {
        return this.start;
    }

    public int getProperty(String name, int defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.intValue();
    }

    public long getProperty(String name, long defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.longValue();
    }

    public float getProperty(String name, float defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.floatValue();
    }

    public double getProperty(String name, double defaultValue) {
        Number value = (Number)this.properties.get(name);
        return value == null ? defaultValue : value.doubleValue();
    }

    public boolean getProperty(String name, boolean defaultValue) {
        Boolean value = (Boolean)this.properties.get(name);
        return value == null ? defaultValue : value;
    }

    public <T> T getProperty(String name, T defaultValue) {
        Object value = this.properties.get(name);
        return (T)(value == null ? defaultValue : value);
    }

    public void setProperty(String name, int value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, long value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, float value) {
        this.properties.put(name, Float.valueOf(value));
    }

    public void setProperty(String name, double value) {
        this.properties.put(name, value);
    }

    public void setProperty(String name, boolean value) {
        this.properties.put(name, value);
    }

    public <T> void setProperty(String name, T value) {
        this.properties.put(name, value);
    }
}

