/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.plugin;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.PluginAccessor;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

public class ModuleDescriptorTestUtils {
    public static <D extends BaseWeightedModuleDescriptor<M>, M> void mockWeightedModuleDescriptors(PluginAccessor pluginAccessor, Class<D> moduleDescriptorClass, M ... modules) {
        ArrayList descriptors = Lists.newArrayList();
        for (M module : modules) {
            BaseWeightedModuleDescriptor descriptor = (BaseWeightedModuleDescriptor)Mockito.mock(moduleDescriptorClass);
            Mockito.when((Object)descriptor.getModule()).thenReturn(module);
            Mockito.when((Object)descriptor.compareTo((BaseWeightedModuleDescriptor)ArgumentMatchers.any(moduleDescriptorClass))).thenAnswer(invocationOnMock -> {
                int thisIndex = descriptors.indexOf(invocationOnMock.getMock());
                int otherIndex = descriptors.indexOf(invocationOnMock.getArguments()[0]);
                return thisIndex - otherIndex;
            });
            descriptors.add(descriptor);
        }
        Mockito.when((Object)pluginAccessor.getEnabledModuleDescriptorsByClass((Class)ArgumentMatchers.eq(moduleDescriptorClass))).thenReturn((Object)descriptors);
    }
}

