/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.attribute.AttributeMap;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.atlassian.bitbucket.io.IoConsumer;
import com.atlassian.bitbucket.job.Job;
import com.atlassian.bitbucket.migration.EntityExportMapping;
import com.atlassian.bitbucket.migration.ErrorStub;
import com.atlassian.bitbucket.migration.ExportContext;
import com.atlassian.bitbucket.migration.ExportSection;
import com.atlassian.bitbucket.migration.MigrationEntityType;
import com.atlassian.bitbucket.migration.SequentialArchive;
import com.google.common.collect.Iterables;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Path;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.core.IsCollectionContaining;
import org.junit.Assert;
import org.junit.rules.TestWatcher;
import org.junit.runner.Description;
import org.mockito.ArgumentMatcher;
import org.mockito.InOrder;
import org.mockito.Mockito;

public class TestableExportContext
extends TestWatcher
implements ExportContext {
    private final Set<Path> assertedSections = new TreeSet<Path>();
    private final AttributeMap attributeMap = new AttributeMap();
    private final ErrorStub errorStub = new ErrorStub();
    private final Job job = (Job)Mockito.mock(Job.class);
    private final ExportSection mainSection = (ExportSection)Mockito.mock(ExportSection.class);
    private final Map<Path, ExportSection> sectionMap = new HashMap<Path, ExportSection>();
    private volatile boolean canceled;
    private volatile boolean noMoreInteractions;

    public static ArgumentMatcher<IoConsumer<SequentialArchive>> sequentialArchive(IoConsumer<SequentialArchive> assertions) {
        return argument -> {
            SequentialArchive mock = (SequentialArchive)Mockito.mock(SequentialArchive.class);
            try {
                argument.accept((Object)mock);
                assertions.accept((Object)mock);
            }
            catch (IOException e) {
                return false;
            }
            return true;
        };
    }

    public void abortIfCanceled() {
        if (this.canceled) {
            throw new RuntimeException("export canceled");
        }
    }

    public void addEntriesAsArchive(@Nonnull Path entryName, @Nonnull IoConsumer<SequentialArchive> writer, boolean compress) {
        this.checkMoreInteractionsAllowed();
        this.mainSection.addEntriesAsArchive(entryName, writer, compress);
    }

    public void addEntry(@Nonnull Path entryName, @Nonnull IoConsumer<OutputStream> writer, boolean compress) {
        this.checkMoreInteractionsAllowed();
        this.mainSection.addEntry(entryName, writer, compress);
    }

    public void addError(@Nonnull KeyedMessage message, Object entity) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addError(message, entity);
    }

    public void addError(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addError(message, entity, t);
    }

    public boolean addSectionIfAbsent(@Nonnull Path path, @Nonnull Consumer<ExportSection> exportSection) {
        this.checkMoreInteractionsAllowed();
        if (!this.sectionMap.containsKey(path)) {
            ExportSection entry = (ExportSection)Mockito.mock(ExportSection.class);
            exportSection.accept(entry);
            this.sectionMap.put(path, entry);
            return true;
        }
        return false;
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addWarning(message, entity, null);
    }

    public void addWarning(@Nonnull KeyedMessage message, Object entity, Throwable t) {
        this.checkMoreInteractionsAllowed();
        this.errorStub.addWarning(message, entity, t);
    }

    public void cancel() {
        this.canceled = true;
    }

    public List<ErrorStub.Message> errors() {
        return this.errorStub.getErrors();
    }

    @Nonnull
    public Asserter expect() {
        this.checkMoreInteractionsAllowed();
        return new Asserter();
    }

    public void expectNoInteractions() {
        this.noMoreInteractions = true;
    }

    @Nonnull
    public AttributeMap getAttributeMap() {
        return this.attributeMap;
    }

    @Nonnull
    public <T> EntityExportMapping<T> getEntityMapping(@Nonnull MigrationEntityType<T> entityType) {
        return (EntityExportMapping)Mockito.spy(new SimpleEntityExportMapping<T>(entityType));
    }

    public boolean hasError(String messageId, Object subject) {
        return this.errors().stream().anyMatch(message -> message.getMessage().equals(messageId) && message.getSubject() == subject);
    }

    public boolean hasErrors() {
        return this.errorStub.hasErrors();
    }

    public boolean hasSection(@Nonnull Path path) {
        this.checkMoreInteractionsAllowed();
        return this.sectionMap.containsKey(path);
    }

    public boolean hasWarning(String messageId, Object subject) {
        return this.warnings().stream().anyMatch(message -> message.getMessage().equals(messageId) && message.getSubject() == subject);
    }

    public List<ErrorStub.Message> warnings() {
        return this.errorStub.getWarnings();
    }

    protected void finished(Description description) {
        try {
            this.expectNoMoreInteractions();
            this.verify();
        }
        finally {
            this.reset();
        }
    }

    private void checkMoreInteractionsAllowed() {
        if (this.noMoreInteractions) {
            throw new IllegalStateException("Expected no more interaction with the ExportContext.");
        }
    }

    private void expectNoMoreInteractions() {
        this.noMoreInteractions = true;
        Mockito.verifyNoMoreInteractions((Object[])new Object[]{this.mainSection, this.job});
        this.sectionMap.values().forEach(xva$0 -> Mockito.verifyNoMoreInteractions((Object[])new Object[]{xva$0}));
    }

    private void reset() {
        this.canceled = false;
        this.noMoreInteractions = false;
        Mockito.reset((Object[])new Object[]{this.job, this.mainSection});
        this.sectionMap.values().forEach(xva$0 -> Mockito.reset((Object[])new ExportSection[]{xva$0}));
        this.sectionMap.clear();
    }

    private void verify() {
        Assert.assertThat(new TreeSet<Path>(this.sectionMap.keySet()), (Matcher)Matchers.equalTo(this.assertedSections));
    }

    public class Asserter {
        public InOrderAsserter inOrder() {
            return new InOrderAsserter();
        }

        public Asserter mainSection(Consumer<ExportSection> sectionConsumer) {
            sectionConsumer.accept(TestableExportContext.this.mainSection);
            return this;
        }

        public Asserter section(Path path, Consumer<ExportSection> sectionConsumer) {
            Assert.assertThat(TestableExportContext.this.sectionMap.keySet(), (Matcher)IsCollectionContaining.hasItem((Object)path));
            ExportSection mockedSection = TestableExportContext.this.sectionMap.get(path);
            sectionConsumer.accept(mockedSection);
            TestableExportContext.this.assertedSections.add(path);
            return this;
        }
    }

    private static class SimpleEntityExportMapping<T>
    implements EntityExportMapping<T> {
        private final MigrationEntityType<T> entityType;

        public SimpleEntityExportMapping(MigrationEntityType<T> entityType) {
            this.entityType = entityType;
        }

        @Nonnull
        public String getExportId(@Nonnull T id) {
            return String.valueOf(id);
        }
    }

    public class InOrderAsserter {
        private final InOrder inOrder;

        public InOrderAsserter() {
            this.inOrder = Mockito.inOrder((Object[])Iterables.toArray((Iterable)Iterables.concat(TestableExportContext.this.sectionMap.values(), Collections.singleton(TestableExportContext.this.mainSection)), Object.class));
        }

        public InOrderAsserter mainSection(BiConsumer<ExportSection, InOrder> sectionConsumer) {
            sectionConsumer.accept(TestableExportContext.this.mainSection, this.inOrder);
            return this;
        }

        public InOrderAsserter section(Path path, BiConsumer<ExportSection, InOrder> sectionConsumer) {
            Assert.assertThat(TestableExportContext.this.sectionMap.keySet(), (Matcher)IsCollectionContaining.hasItem((Object)path));
            ExportSection mockedSection = TestableExportContext.this.sectionMap.get(path);
            sectionConsumer.accept(mockedSection, this.inOrder);
            TestableExportContext.this.assertedSections.add(path);
            return this;
        }
    }
}

