/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.migration;

import com.atlassian.bitbucket.migration.EntityImportMapping;
import com.google.common.collect.BiMap;
import com.google.common.collect.HashBiMap;
import java.util.Optional;
import javax.annotation.Nonnull;

public class SimpleEntityImportMapping<K>
implements EntityImportMapping<K> {
    private final BiMap<String, K> mapping = HashBiMap.create();

    public void add(@Nonnull String exportId, @Nonnull K localId) {
        String existingExportId = (String)this.mapping.inverse().get(localId);
        if (existingExportId != null) {
            throw new IllegalArgumentException("'" + exportId + "' already mapped to '" + existingExportId + "'");
        }
        Object existingLocalId = this.mapping.putIfAbsent((Object)exportId, localId);
        if (existingLocalId != null) {
            throw new IllegalArgumentException("'" + exportId + "' already mapped to '" + existingLocalId + "'");
        }
    }

    public void clear() {
        this.mapping.clear();
    }

    @Nonnull
    public Optional<String> getExportId(@Nonnull K localId) {
        return Optional.ofNullable((String)this.mapping.inverse().get(localId));
    }

    @Nonnull
    public Optional<K> getLocalId(@Nonnull String exportId) {
        return Optional.ofNullable(this.mapping.get((Object)exportId));
    }

    public boolean hasMappings() {
        return !this.mapping.isEmpty();
    }
}

