/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.i18n;

import com.atlassian.bitbucket.i18n.I18nKey;
import com.atlassian.bitbucket.i18n.I18nService;
import com.atlassian.bitbucket.i18n.KeyedMessage;
import com.google.common.base.Joiner;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class SimpleI18nService
implements I18nService {
    private final Mode mode;

    public SimpleI18nService() {
        this(Mode.RETURN_KEYS);
    }

    public SimpleI18nService(Mode mode) {
        this.mode = mode;
    }

    @Nonnull
    public KeyedMessage createKeyedMessage(@Nonnull String key, Object ... arguments) {
        return this.getKeyedText(key, null, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull String key, Object ... arguments) {
        return this.getText(key, null, arguments);
    }

    @Nonnull
    public String getMessage(@Nonnull I18nKey key) {
        return this.getText(key.getKey(), null, key.getArguments());
    }

    @Nonnull
    public String getMessage(@Nonnull Locale locale, @Nonnull String key, Object ... arguments) {
        return this.getText(locale, key, key, arguments);
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix) {
        return Collections.emptyMap();
    }

    @Nonnull
    public Map<String, String> getAllTranslationsForPrefix(@Nonnull String prefix, @Nonnull Locale locale) {
        return this.getAllTranslationsForPrefix(prefix);
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        String message = this.getText(key, fallbackMessage, arguments);
        return new KeyedMessage(StringUtils.defaultString((String)key), StringUtils.defaultString((String)message), StringUtils.defaultString((String)message));
    }

    public String getMessagePattern(@Nonnull String key) {
        return this.getMessagePattern(key, null);
    }

    public String getMessagePattern(@Nonnull String key, String fallbackPattern) {
        return fallbackPattern;
    }

    public String getMessagePattern(@Nonnull Locale locale, @Nonnull String key) {
        return this.getMessagePattern(key, null);
    }

    @Nonnull
    public KeyedMessage getKeyedText(@Nonnull I18nKey i18nKey) {
        return this.createKeyedMessage(i18nKey.getKey(), i18nKey.getArguments());
    }

    @Nonnull
    public String getText(@Nonnull Locale locale, @Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.getText(key, fallbackMessage, arguments);
    }

    @Nonnull
    public String getText(@Nonnull String key, String fallbackMessage, Object ... arguments) {
        return this.mode.apply(key, fallbackMessage, arguments);
    }

    public Matcher<KeyedMessage> keyedMessageMatcherFor(String key, Object ... arguments) {
        return new KeyedMessageMatcher(this.mode, key, null, arguments);
    }

    /*
     * Uses 'sealed' constructs - enablewith --sealed true
     */
    public static enum Mode {
        FORMAT_MESSAGES{

            @Override
            public String apply(String key, String fallbackMessage, Object ... arguments) {
                return MessageFormat.format(fallbackMessage, arguments);
            }
        }
        ,
        RETURN_KEYS{

            @Override
            public String apply(String key, String fallbackMessage, Object ... arguments) {
                return key;
            }
        }
        ,
        RETURN_KEYS_WITH_ARGUMENTS{

            @Override
            public String apply(String key, String fallbackMessage, Object ... arguments) {
                if (arguments.length == 0) {
                    return key;
                }
                return key + "(" + Joiner.on((String)", ").join(arguments) + ")";
            }
        }
        ,
        RETURN_MESSAGES{

            @Override
            public String apply(String key, String fallbackMessage, Object ... arguments) {
                return fallbackMessage;
            }
        };


        public abstract String apply(String var1, String var2, Object ... var3);
    }

    private static class KeyedMessageMatcher
    extends TypeSafeDiagnosingMatcher<KeyedMessage> {
        private final String key;
        private final String message;

        private KeyedMessageMatcher(Mode mode, String key, String fallback, Object ... arguments) {
            this.key = key;
            this.message = mode.apply(key, fallback, arguments);
        }

        protected boolean matchesSafely(KeyedMessage item, Description mismatchDescription) {
            if (Objects.equals(this.key, item.getKey()) && Objects.equals(this.message, item.getRootMessage()) && Objects.equals(this.message, item.getLocalisedMessage())) {
                return true;
            }
            mismatchDescription.appendValue((Object)String.format("{key: %s, localMessage: %s, rootMessage: %s}", item.getKey(), item.getLocalisedMessage(), item.getRootMessage()));
            return false;
        }

        public void describeTo(Description description) {
            description.appendValue((Object)String.format("{key: %1$s, localMessage: %2$s, rootMessage: %2$s}", this.key, this.message));
        }
    }
}

