/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.util.MoreFiles;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeMatcher;
import org.hamcrest.core.IsEqual;

public class PathMatchers {
    private PathMatchers() {
        throw new UnsupportedOperationException("Attempt to instantiate utility class");
    }

    public static Matcher<Path> exists() {
        return new TypeSafeMatcher<Path>(){
            private Path fileTested;

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                return Files.exists(item, new LinkOption[0]);
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" exists");
            }
        };
    }

    public static Matcher<Path> isDirectory() {
        return new TypeSafeMatcher<Path>(){
            private Path fileTested;

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                return Files.isDirectory(item, new LinkOption[0]);
            }

            public void describeTo(Description description) {
                description.appendText(" that ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is a directory");
            }
        };
    }

    public static Matcher<Path> isFile() {
        return new TypeSafeMatcher<Path>(){
            private Path fileTested;

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                return Files.isRegularFile(item, new LinkOption[0]);
            }

            public void describeTo(Description description) {
                description.appendText(" that ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is a file");
            }
        };
    }

    public static Matcher<Path> named(final Matcher<String> name) {
        return new TypeSafeMatcher<Path>(){
            private Path fileTested;

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" is named");
                description.appendDescriptionOf((SelfDescribing)name);
                description.appendText(" not ");
                description.appendValue((Object)this.fileTested.getFileName());
            }

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                return name.matches((Object)item.getFileName().toString());
            }
        };
    }

    public static Matcher<Path> readable() {
        return new TypeSafeMatcher<Path>(){
            private Path fileTested;

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                return Files.isReadable(item);
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is readable");
            }
        };
    }

    public static Matcher<Path> sized(long size) {
        return PathMatchers.sized((Matcher<Long>)IsEqual.equalTo((Object)size));
    }

    public static Matcher<Path> sized(final Matcher<Long> size) {
        return new TypeSafeMatcher<Path>(){
            Path fileTested;
            long length;

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                this.length = MoreFiles.size((Path)item);
                return size.matches((Object)this.length);
            }

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText(" is sized ");
                description.appendDescriptionOf((SelfDescribing)size);
                description.appendText(", not " + this.length);
            }
        };
    }

    public static Matcher<Path> withAbsolutePath(final Matcher<String> path) {
        return new TypeSafeMatcher<Path>(){

            public void describeTo(Description description) {
                description.appendText("with absolute path '");
                description.appendDescriptionOf((SelfDescribing)path);
                description.appendText("'");
            }

            public boolean matchesSafely(Path item) {
                return path.matches((Object)item.toAbsolutePath().toString());
            }
        };
    }

    public static Matcher<Path> withRealPath(final Matcher<String> path) {
        return new TypeSafeMatcher<Path>(){

            public void describeTo(Description description) {
                description.appendText("with real path '");
                description.appendDescriptionOf((SelfDescribing)path);
                description.appendText("'");
            }

            public boolean matchesSafely(Path item) {
                try {
                    return path.matches((Object)item.toRealPath(new LinkOption[0]).toString());
                }
                catch (IOException e) {
                    return false;
                }
            }
        };
    }

    public static Matcher<Path> writable() {
        return new TypeSafeMatcher<Path>(){
            private Path fileTested;

            public void describeTo(Description description) {
                description.appendText(" that file ");
                description.appendValue((Object)this.fileTested);
                description.appendText("is writable");
            }

            public boolean matchesSafely(Path item) {
                this.fileTested = item;
                return Files.isWritable(item);
            }
        };
    }
}

