/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.smtp.MailTestUtils;
import com.google.common.collect.Lists;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class EmailMatcher
extends TypeSafeMatcher<MimeMessage> {
    private Matcher<? super String> bodyAsTextMatcher;
    private Matcher<? super String> bodyMatcher;
    private String addressedTo;
    private Matcher<? super String> subjectMatcher;
    private Map<String, String> expectedHeaders = new HashMap<String, String>();

    public boolean matchesSafely(MimeMessage message) {
        try {
            String bodyContent;
            if (this.addressedTo != null) {
                Address[] recipientsArray = message.getRecipients(Message.RecipientType.TO);
                if (recipientsArray != null) {
                    List recipients = Lists.transform(Arrays.asList(recipientsArray), Object::toString);
                    if (!recipients.contains(this.addressedTo)) {
                        return false;
                    }
                } else {
                    return false;
                }
            }
            if (!this.expectedHeaders.isEmpty()) {
                for (String header : this.expectedHeaders.keySet()) {
                    String expectedValue = this.expectedHeaders.get(header);
                    String[] actualValues = message.getHeader(header);
                    if (actualValues == null) {
                        return false;
                    }
                    if (actualValues.length > 1) {
                        throw new UnsupportedOperationException("EmailMatcher is currently unable to verify headers with multiple values.  Write this when you need it!");
                    }
                    if (expectedValue.equals(actualValues[0])) continue;
                    return false;
                }
            }
            if (this.subjectMatcher != null && !this.subjectMatcher.matches((Object)message.getSubject())) {
                return false;
            }
            if (this.bodyAsTextMatcher != null && !this.bodyAsTextMatcher.matches((Object)(bodyContent = MailTestUtils.getContentAsText(message)))) {
                return false;
            }
            return this.bodyMatcher == null || this.bodyMatcher.matches((Object)(bodyContent = MailTestUtils.getContent(message)));
        }
        catch (MessagingException e) {
            throw new RuntimeException("Error trying to compare email message", e);
        }
    }

    public void describeTo(Description desc) {
        desc.appendText("an email");
        if (this.addressedTo != null) {
            desc.appendText(" addressed to ").appendText(this.addressedTo);
        }
        if (!this.expectedHeaders.isEmpty()) {
            for (String header : this.expectedHeaders.keySet()) {
                desc.appendText(" with header ").appendText(header).appendText("=").appendText(this.expectedHeaders.get(header));
            }
        }
        if (this.subjectMatcher != null) {
            desc.appendText(" with subject ").appendDescriptionOf(this.subjectMatcher);
        }
        if (this.bodyAsTextMatcher != null) {
            desc.appendText(" with body as text ").appendDescriptionOf(this.bodyAsTextMatcher);
        }
        if (this.bodyMatcher != null) {
            desc.appendText(" with body ").appendDescriptionOf(this.bodyMatcher);
        }
    }

    public EmailMatcher withBodyAsText(Matcher<? super String> bodyAsTextMatcher) {
        this.bodyAsTextMatcher = bodyAsTextMatcher;
        return this;
    }

    public EmailMatcher withBody(Matcher<? super String> bodyMatcher) {
        this.bodyMatcher = bodyMatcher;
        return this;
    }

    public EmailMatcher withSubject(Matcher<? super String> subjectMatcher) {
        this.subjectMatcher = subjectMatcher;
        return this;
    }

    public EmailMatcher addressedTo(String address) {
        this.addressedTo = address;
        return this;
    }

    public EmailMatcher withHeader(String header, String expectedValue) {
        this.expectedHeaders.put(header, expectedValue);
        return this;
    }
}

