/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.dbunit;

import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.dbunit.DatabaseUnitException;
import org.dbunit.database.DatabaseConfig;
import org.dbunit.database.DatabaseConnection;
import org.dbunit.database.IDatabaseConnection;
import org.dbunit.dataset.datatype.DefaultDataTypeFactory;
import org.dbunit.dataset.datatype.IDataTypeFactory;
import org.dbunit.ext.h2.H2DataTypeFactory;
import org.dbunit.ext.hsqldb.HsqldbDataTypeFactory;
import org.dbunit.ext.mssql.MsSqlDataTypeFactory;
import org.dbunit.ext.oracle.Oracle10DataTypeFactory;
import org.dbunit.ext.oracle.OracleDataTypeFactory;
import org.dbunit.ext.postgresql.PostgresqlDataTypeFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DatabaseConnectionFactory {
    private static final Logger log = LoggerFactory.getLogger(DatabaseConnectionFactory.class);
    private final DataSource dataSource;
    private volatile IDataTypeFactory dataTypeFactory;

    public DatabaseConnectionFactory(DataSource dataSource) {
        this.dataSource = dataSource;
    }

    public IDatabaseConnection newConnection() throws DatabaseUnitException, SQLException {
        Connection jdbcConnection = this.dataSource.getConnection();
        if (this.dataTypeFactory == null) {
            this.dataTypeFactory = this.resolveDataTypeFactory(jdbcConnection);
        }
        String schema = null;
        if (this.dataTypeFactory instanceof OracleDataTypeFactory) {
            schema = StringUtils.upperCase((String)jdbcConnection.getMetaData().getUserName());
        }
        DatabaseConnection connection = new DatabaseConnection(jdbcConnection, schema);
        DatabaseConfig configuration = connection.getConfig();
        configuration.setProperty("http://www.dbunit.org/properties/datatypeFactory", (Object)this.dataTypeFactory);
        return connection;
    }

    private IDataTypeFactory resolveDataTypeFactory(Connection connection) throws SQLException {
        HsqldbDataTypeFactory factory;
        DatabaseMetaData metaData = connection.getMetaData();
        String databaseName = metaData.getDatabaseProductName();
        if ("HSQL Database Engine".equals(databaseName)) {
            log.debug("Using HSQL DataTypeFactory");
            factory = new HsqldbDataTypeFactory();
        } else if ("H2".equals(databaseName)) {
            log.debug("Using H2 DataTypeFactory");
            factory = new H2DataTypeFactory();
        } else if ("PostgreSQL".equals(databaseName)) {
            log.debug("Using Postgres DataTypeFactory");
            factory = new PostgresqlDataTypeFactory();
        } else if (databaseName.startsWith("Microsoft SQL Server")) {
            log.debug("Using SQL Server DataTypeFactory");
            factory = new MsSqlDataTypeFactory();
        } else if ("Oracle".equals(databaseName)) {
            if (metaData.getDatabaseMajorVersion() < 10) {
                log.debug("Using Oracle DataTypeFactory for 10g and later");
                factory = new OracleDataTypeFactory();
            } else {
                log.debug("Using Oracle DataTypeFactory for 9i and earlier");
                factory = new Oracle10DataTypeFactory();
            }
        } else {
            log.warn("No IDataTypeFactory was resolved for {}. Using default DataTypeFactory. This may result in test failures. If so, please update {} with an explicit DataTypeFactory for this database.", (Object)databaseName, this.getClass());
            return new DefaultDataTypeFactory();
        }
        return factory;
    }
}

