/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.context;

import com.atlassian.bitbucket.context.ChainTestExecutionListener;
import java.util.Collection;
import java.util.Map;
import org.springframework.beans.factory.BeanFactoryUtils;
import org.springframework.beans.factory.ListableBeanFactory;
import org.springframework.context.ApplicationContext;
import org.springframework.test.context.TestContext;
import org.springframework.test.context.TestExecutionListener;
import org.springframework.test.context.support.AbstractTestExecutionListener;
import org.springframework.test.context.support.DependencyInjectionTestExecutionListener;

public class DelegatingTestExecutionListener
implements TestExecutionListener {
    private TestExecutionListener delegate;

    public void afterTestClass(TestContext testContext) throws Exception {
        this.getDelegate(testContext).afterTestClass(testContext);
    }

    public void afterTestMethod(TestContext testContext) throws Exception {
        this.getDelegate(testContext).afterTestMethod(testContext);
    }

    public void beforeTestClass(TestContext testContext) throws Exception {
        this.getDelegate(testContext).beforeTestClass(testContext);
    }

    public void beforeTestMethod(TestContext testContext) throws Exception {
        this.getDelegate(testContext).beforeTestMethod(testContext);
    }

    public void prepareTestInstance(TestContext testContext) throws Exception {
        this.getDelegate(testContext).prepareTestInstance(testContext);
    }

    protected TestExecutionListener getDelegate(TestContext context) {
        if (this.delegate == null || this.isDirty(context)) {
            ApplicationContext applicationContext;
            try {
                applicationContext = context.getApplicationContext();
            }
            catch (Error | RuntimeException e) {
                this.delegate = new NullTestExecutionListener();
                throw e;
            }
            Map beans = BeanFactoryUtils.beansOfTypeIncludingAncestors((ListableBeanFactory)applicationContext, TestExecutionListener.class);
            Collection<TestExecutionListener> listeners = beans.values();
            this.delegate = listeners.size() == 1 ? (TestExecutionListener)listeners.iterator().next() : new ChainTestExecutionListener(listeners);
        }
        return this.delegate;
    }

    protected boolean isDirty(TestContext context) {
        return Boolean.TRUE.equals(context.getAttribute(DependencyInjectionTestExecutionListener.REINJECT_DEPENDENCIES_ATTRIBUTE));
    }

    private static class NullTestExecutionListener
    extends AbstractTestExecutionListener {
        private NullTestExecutionListener() {
        }
    }
}

