/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rule;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.junit.rules.MethodRule;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.Statement;

public class ParameterizedRule<T>
implements MethodRule {
    private final List<T> parameters;
    private int currentIndex;

    public ParameterizedRule(Collection<T> parameters) {
        this.parameters = new ArrayList<T>(parameters);
    }

    public Statement apply(final Statement base, FrameworkMethod method, Object target) {
        return new Statement(){

            public void evaluate() throws Throwable {
                for (int i = 0; i < ParameterizedRule.this.parameters.size(); ++i) {
                    ParameterizedRule.this.currentIndex = i;
                    base.evaluate();
                }
            }
        };
    }

    public T getParameter() {
        return this.parameters.get(this.currentIndex);
    }
}

