/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.permission;

import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.permission.PermissionCheck;
import com.atlassian.bitbucket.permission.PermissionVote;
import com.atlassian.bitbucket.permission.PermissionVoter;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public class PermissionVoterTestUtils {
    private PermissionVoterTestUtils() {
        throw new UnsupportedOperationException("PermissionVoterTestUtils is a utility class that shouldn't be instantiated");
    }

    @Nonnull
    public static PermissionCheck permissionCheck(@Nonnull Permission permission, @Nullable Object resource) {
        return PermissionVoterTestUtils.permissionCheck(permission, resource, PermissionVote.ABSTAIN);
    }

    @Nonnull
    public static PermissionCheck permissionCheck(@Nonnull Permission permission, @Nullable Object resource, @Nonnull PermissionVote currentVote) {
        return new SimplePermissionCheck(permission, resource, currentVote);
    }

    @Nonnull
    public static PermissionVote vote(PermissionVoter voter, Permission permission, Object resource) {
        return PermissionVoterTestUtils.vote(voter, permission, resource, PermissionVote.ABSTAIN);
    }

    @Nonnull
    public static PermissionVote vote(PermissionVoter voter, Permission permission, Object resource, PermissionVote currentVote) {
        return voter.vote(PermissionVoterTestUtils.permissionCheck(permission, resource, currentVote));
    }

    private static class SimplePermissionCheck
    implements PermissionCheck {
        private final Permission permission;
        private final Object resource;
        private final PermissionVote result;

        private SimplePermissionCheck(Permission permission, Object resource, PermissionVote result) {
            this.permission = Objects.requireNonNull(permission, "permission");
            this.resource = resource;
            this.result = Objects.requireNonNull(result, "result");
        }

        @Nonnull
        public Permission getPermission() {
            return this.permission;
        }

        @Nonnull
        public Optional<Object> getResource() {
            return Optional.ofNullable(this.resource);
        }

        @Nonnull
        public PermissionVote getResult() {
            return this.result;
        }
    }
}

