/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.hamcrest.FileContentsMatcher;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.base.Joiner;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.nio.file.FileVisitResult;
import java.nio.file.FileVisitor;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.SimpleFileVisitor;
import java.nio.file.attribute.BasicFileAttributes;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Predicate;
import java.util.stream.Stream;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeMatcher;

public class DirectoryTreeMatcher
extends TypeSafeMatcher<Path> {
    private final Path expected;
    private final String expectedDirTree;
    private final Predicate<Path> filter;
    private final boolean ignoreFileContents;
    private final boolean ignoreEmptyDirs;
    private String actualDirTree;
    private TypeSafeMatcher<Path> failingMatcher;

    private DirectoryTreeMatcher(@Nonnull Builder builder) {
        super(Path.class);
        this.ignoreFileContents = builder.ignoreFileContents;
        this.ignoreEmptyDirs = builder.ignoreEmptyDirs;
        this.expected = builder.expected;
        this.filter = (Predicate)MoreObjects.firstNonNull((Object)builder.filter, any -> true);
        this.expectedDirTree = this.buildDirTree(this.expected);
    }

    @Nonnull
    public static Builder builder(@Nonnull Path expected) {
        return new Builder(Objects.requireNonNull(expected, "expected"));
    }

    public void describeTo(Description description) {
        if (this.failingMatcher == null) {
            description.appendText("directory tree: \n");
            description.appendText(this.expectedDirTree + "\n");
        } else {
            this.failingMatcher.describeTo(description);
        }
    }

    protected void describeMismatchSafely(Path item, Description mismatchDescription) {
        if (this.failingMatcher == null) {
            mismatchDescription.appendText("instead got: \n");
            mismatchDescription.appendText(this.actualDirTree + "\n");
        } else {
            this.failingMatcher.describeMismatch((Object)item, mismatchDescription);
        }
    }

    protected boolean matchesSafely(Path actual) {
        this.actualDirTree = this.buildDirTree(actual);
        return this.expectedDirTree.equals(this.actualDirTree) && (this.ignoreFileContents || this.matchFileContents(actual));
    }

    @Nonnull
    private String buildDirTree(@Nonnull Path root) {
        return Joiner.on((String)"\n").join(new DirTree(root, this.filter, this.ignoreEmptyDirs).getAsPrintableLines());
    }

    private boolean matchFileContents(final @Nonnull Path actual) {
        final AtomicBoolean matches = new AtomicBoolean(true);
        try {
            Files.walkFileTree(this.expected, (FileVisitor<? super Path>)new SimpleFileVisitor<Path>(){

                @Override
                public FileVisitResult preVisitDirectory(Path dir, BasicFileAttributes attrs) throws IOException {
                    if (!DirectoryTreeMatcher.this.filter.test(dir)) {
                        return FileVisitResult.SKIP_SUBTREE;
                    }
                    return super.preVisitDirectory(dir, attrs);
                }

                @Override
                public FileVisitResult visitFile(Path file, BasicFileAttributes attrs) {
                    if (!DirectoryTreeMatcher.this.filter.test(file)) {
                        return FileVisitResult.CONTINUE;
                    }
                    FileContentsMatcher contentsMatcher = new FileContentsMatcher(file);
                    Path relativePath = DirectoryTreeMatcher.this.expected.relativize(file);
                    Path actualPath = actual.resolve(relativePath);
                    if (!contentsMatcher.matches(actualPath)) {
                        matches.set(false);
                        DirectoryTreeMatcher.this.failingMatcher = contentsMatcher;
                        return FileVisitResult.TERMINATE;
                    }
                    return FileVisitResult.CONTINUE;
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return matches.get();
    }

    public static class Builder {
        private final Path expected;
        private boolean ignoreEmptyDirs;
        private boolean ignoreFileContents;
        private Predicate<Path> filter;

        public Builder(@Nonnull Path expected) {
            this.expected = Objects.requireNonNull(expected, "expected");
        }

        @Nonnull
        public Builder ignoreFileContents() {
            this.ignoreFileContents = true;
            return this;
        }

        @Nonnull
        public Builder ignoreEmptyDirs() {
            this.ignoreEmptyDirs = true;
            return this;
        }

        @Nonnull
        public Builder filter(@Nullable Predicate<Path> filter) {
            this.filter = filter;
            return this;
        }

        @Nonnull
        public DirectoryTreeMatcher build() {
            return new DirectoryTreeMatcher(this);
        }
    }

    private static class FileNode
    extends DirTreeNode {
        FileNode(@Nonnull Path path) {
            super(path.getFileName().toString());
        }

        @Override
        @Nonnull
        List<String> getAsPrintableLines(@Nonnull String prefix, boolean lastEntryInDir) {
            return ImmutableList.of((Object)(prefix + (lastEntryInDir ? "\u2514\u2500" : "\u251c\u2500") + this.name));
        }
    }

    private static class DirNode
    extends DirTreeNode {
        final List<DirTreeNode> children;
        private final boolean ignoreEmptyDirs;

        DirNode(@Nonnull Path path, @Nonnull Predicate<Path> filter, boolean ignoreEmptyDirs) {
            super(path.getFileName().toString());
            Preconditions.checkArgument((boolean)Files.isDirectory(path, new LinkOption[0]), (Object)"'path' must be a directory.");
            this.ignoreEmptyDirs = ignoreEmptyDirs;
            this.children = (List)DirNode.listDirEntries(path, filter).stream().map(nodePath -> Files.isDirectory(nodePath, new LinkOption[0]) ? new DirNode((Path)nodePath, filter, ignoreEmptyDirs) : new FileNode((Path)nodePath)).filter(node -> !ignoreEmptyDirs || this.isNotEmptyDir((DirTreeNode)node)).collect(MoreCollectors.toImmutableList());
        }

        private boolean isNotEmptyDir(DirTreeNode node) {
            return node instanceof FileNode || !((DirNode)node).children.isEmpty();
        }

        @Override
        @Nonnull
        List<String> getAsPrintableLines(@Nonnull String prefix, boolean lastEntryInDir) {
            if (this.ignoreEmptyDirs && this.children.isEmpty()) {
                return ImmutableList.of();
            }
            ImmutableList.Builder lines = ImmutableList.builder();
            lines.add((Object)(prefix + (lastEntryInDir ? "\u2514\u2500" : "\u251c\u2500") + this.name));
            Iterator<DirTreeNode> childrenIter = this.children.iterator();
            while (childrenIter.hasNext()) {
                DirTreeNode nextChild = childrenIter.next();
                lines.addAll(nextChild.getAsPrintableLines(prefix + (lastEntryInDir ? "  " : "\u2502 "), !childrenIter.hasNext()));
            }
            return lines.build();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Nonnull
        private static List<Path> listDirEntries(@Nonnull Path dir, @Nonnull Predicate<Path> filter) {
            try (Stream<Path> dirEntries = Files.list(dir);){
                List list = (List)dirEntries.filter(filter).sorted(Comparator.comparing(Path::getFileName)).collect(MoreCollectors.toImmutableList());
                return list;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static abstract class DirTreeNode {
        protected final String name;

        DirTreeNode(@Nonnull String name) {
            this.name = name;
        }

        @Nonnull
        abstract List<String> getAsPrintableLines(@Nonnull String var1, boolean var2);
    }

    private static class DirTree {
        private final DirTreeNode rootNode;

        DirTree(@Nonnull Path path, @Nonnull Predicate<Path> filter, boolean ignoreEmptyDirs) {
            this.rootNode = Files.isDirectory(path, new LinkOption[0]) ? new DirNode(path, filter, ignoreEmptyDirs) : new FileNode(path);
        }

        @Nonnull
        List<String> getAsPrintableLines() {
            if (this.rootNode instanceof FileNode) {
                return ImmutableList.of((Object)this.rootNode.name);
            }
            ImmutableList.Builder lines = ImmutableList.builder();
            lines.add((Object)".");
            Iterator<DirTreeNode> childrenIter = ((DirNode)this.rootNode).children.iterator();
            while (childrenIter.hasNext()) {
                lines.addAll(childrenIter.next().getAsPrintableLines("", !childrenIter.hasNext()));
            }
            return lines.build();
        }
    }
}

