/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.smtp;

import com.atlassian.bitbucket.mail.MailHostConfiguration;
import com.atlassian.bitbucket.smtp.GreenMailSmtpServer;
import com.atlassian.bitbucket.smtp.SmtpServer;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableSet;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.ObjectUtils;
import org.apache.commons.lang3.StringUtils;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.junit.Assert;

public class MailTestUtils {
    private static final Comparator<MimeMessage> SENT_DATE_COMPARATOR = new Comparator<MimeMessage>(){

        @Override
        public int compare(MimeMessage m1, MimeMessage m2) {
            try {
                int c = ObjectUtils.compare((Comparable)m1.getSentDate(), (Comparable)m2.getSentDate());
                if (c == 0) {
                    return ObjectUtils.compare((Comparable)m1.getReceivedDate(), (Comparable)m2.getReceivedDate());
                }
                return c;
            }
            catch (MessagingException e) {
                throw new IllegalStateException(e);
            }
        }
    };

    public static int getSmtpPort() {
        return Integer.getInteger("stash.test.smtp.port", 9999);
    }

    public static SmtpServer createNewSMTPServer() {
        return new GreenMailSmtpServer(MailTestUtils.getSmtpPort());
    }

    public static MailHostConfiguration getSmtpConfiguration() {
        return new MailHostConfiguration.Builder().hostname("localhost").port(Integer.valueOf(MailTestUtils.getSmtpPort())).build();
    }

    public static Set<Address> getRecipients(MimeMessage email, Message.RecipientType type) throws MessagingException {
        Object[] recipients = email.getRecipients(type);
        return recipients == null ? Collections.emptySet() : ImmutableSet.copyOf((Object[])recipients);
    }

    public static void assertRecipients(MimeMessage email, Message.RecipientType type, int expectCount) throws MessagingException {
        Set<Address> recipients = MailTestUtils.getRecipients(email, type);
        Assert.assertThat(recipients, (Matcher)Matchers.hasSize((int)expectCount));
    }

    public static void assertSubjectContains(MimeMessage email, String ... fragments) throws MessagingException {
        String subject = email.getSubject().toLowerCase();
        for (String fragment : fragments) {
            Assert.assertThat((Object)subject, (Matcher)Matchers.containsString((String)fragment.toLowerCase()));
        }
    }

    public static String getContent(MimeMessage email) {
        try {
            return IOUtils.toString((InputStream)email.getInputStream());
        }
        catch (IOException | MessagingException e) {
            throw new IllegalStateException(e);
        }
    }

    public static String getContentAsText(MimeMessage email) {
        return MailTestUtils.htmlToText(MailTestUtils.getContent(email));
    }

    public static String htmlToText(String html) {
        return html.replaceAll("<[^>]+>", "").replaceAll("\\s+", " ").trim();
    }

    public static MimeMessage[] sortBySentDate(MimeMessage[] emails) {
        Arrays.sort(emails, SENT_DATE_COMPARATOR);
        return emails;
    }

    public static String asFormattedString(List<MimeMessage> emails) throws MessagingException {
        StringBuilder sb = new StringBuilder().append(emails.size()).append(" email(s):");
        for (int i = 0; i < emails.size(); ++i) {
            MimeMessage email = emails.get(i);
            sb.append("\n- email ").append(i).append(":\n * TO: ");
            Joiner.on((String)"; ").appendTo(sb, (Object[])email.getRecipients(Message.RecipientType.TO));
            sb.append("\n * SUBJECT: ").append(StringUtils.defaultString((String)email.getSubject()));
            sb.append("\n * CONTENT: ").append(MailTestUtils.getContentAsText(email));
        }
        return sb.toString();
    }
}

