/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.StringDescription;

public class MatcherBuilder {
    private List<String> errors = new ArrayList<String>();

    public MatcherBuilder equal(String name, Object expected, Object actual) {
        return this.matches(name, Matchers.equalTo((Object)expected), actual);
    }

    public <T> MatcherBuilder matches(String name, Matcher<? super T> matcher, T actual) {
        if (!matcher.matches(actual)) {
            StringDescription mismatchDescription = new StringDescription();
            matcher.describeMismatch(actual, (Description)mismatchDescription);
            this.errors.add(String.format("%s: %s", name, mismatchDescription.toString()));
        }
        return this;
    }

    public boolean collect(Description mismatchDescription) {
        if (this.errors.isEmpty()) {
            return true;
        }
        mismatchDescription.appendText(this.errors.stream().collect(Collectors.joining(", ")));
        return false;
    }
}

