/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.search;

import com.atlassian.bitbucket.search.DockerElasticsearchSingleNode;
import com.atlassian.bitbucket.search.EmbeddedElasticsearchSingleNode;
import java.net.URI;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import org.apache.commons.lang3.StringUtils;
import org.junit.rules.ExternalResource;

public abstract class ElasticsearchSingleNode
extends ExternalResource {
    protected static final String SEARCH_INDEX_NAME = "bitbucket-search";

    public static Builder builder() {
        return new Builder();
    }

    public abstract List<String> analyze(String var1, String var2);

    public abstract void checkClusterHealth();

    public abstract Map<String, List<String>> getAliases();

    public abstract String getVersion();

    @Nonnull
    public abstract URI serverBaseUrl();

    protected abstract void before() throws Throwable;

    protected abstract void after();

    public static final class Builder {
        private Integer httpPort;
        private Integer tcpPort;

        private Builder() {
        }

        public Builder httpPort(int httpPort) {
            this.httpPort = httpPort;
            return this;
        }

        public Builder tcpPort(int tcpPort) {
            this.tcpPort = tcpPort;
            return this;
        }

        @Nonnull
        public ElasticsearchSingleNode build() {
            String elasticsearchHost = System.getProperty("elasticsearch.host");
            String elasticsearchPort = System.getProperty("elasticsearch.port");
            if (StringUtils.isNotEmpty((CharSequence)elasticsearchHost) && this.httpPort == null && this.tcpPort == null) {
                return new DockerElasticsearchSingleNode(elasticsearchHost, Integer.parseInt(elasticsearchPort));
            }
            return new EmbeddedElasticsearchSingleNode(this.httpPort, this.tcpPort);
        }
    }
}

