/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.ao;

import com.atlassian.activeobjects.spi.DatabaseType;
import com.atlassian.bitbucket.ao.SystemPropertyJdbcConfiguration;
import com.atlassian.bitbucket.util.MoreCollectors;
import com.google.common.collect.ImmutableMap;
import java.lang.reflect.Method;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import net.java.ao.Accessor;
import net.java.ao.EntityManager;
import net.java.ao.RawEntity;
import net.java.ao.schema.Indexed;
import net.java.ao.schema.PrimaryKey;
import net.java.ao.schema.Unique;
import net.java.ao.test.jdbc.Jdbc;
import net.java.ao.test.junit.ActiveObjectsJUnitRunner;
import org.junit.Assert;
import org.junit.Test;
import org.junit.experimental.categories.Category;
import org.junit.runner.RunWith;

@RunWith(value=ActiveObjectsJUnitRunner.class)
@Jdbc(value=SystemPropertyJdbcConfiguration.class)
@Category(value={AbstractAoDaoTest.class})
public abstract class AbstractAoDaoTest {
    private static final Pattern JDBC_PATTERN = Pattern.compile("^(jdbc(?::\\w+)+)(?:\\W.*)?");
    protected EntityManager entityManager;
    private final List<Class<? extends RawEntity<?>>> entityClasses;

    public AbstractAoDaoTest() {
        this.entityClasses = null;
    }

    @SafeVarargs
    public AbstractAoDaoTest(Class<? extends RawEntity<?>> entityClass, Class<? extends RawEntity<?>> ... entityClasses) {
        this.entityClasses = (List)Stream.concat(Stream.of(entityClass), Stream.of(entityClasses)).filter(Objects::nonNull).collect(MoreCollectors.toImmutableList());
    }

    @Test
    public void testAnnotations() {
        if (this.entityClasses == null || this.entityClasses.isEmpty()) {
            return;
        }
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Class<RawEntity<?>> entityClass : this.entityClasses) {
            List<String> invalidAnnotations = AbstractAoDaoTest.checkAnnotations(entityClass);
            if (invalidAnnotations.isEmpty()) continue;
            builder.put((Object)entityClass.getSimpleName(), invalidAnnotations);
        }
        ImmutableMap invalidEntities = builder.build();
        if (!invalidEntities.isEmpty()) {
            Assert.fail((String)("One or more entities have invalid annotations:\n\n" + invalidEntities.entrySet().stream().map(entry -> (String)entry.getKey() + AbstractAoDaoTest.toBulletedList((List)entry.getValue())).collect(Collectors.joining("\n"))));
        }
    }

    @Test
    public void testUsingCorrectDatabase() throws Exception {
        Connection connection = null;
        try {
            connection = this.entityManager.getProvider().getConnection();
            String expectedUrl = AbstractAoDaoTest.getJdbcUrl();
            Assert.assertEquals((Object)AbstractAoDaoTest.getJdbcProtocolFor(expectedUrl), (Object)AbstractAoDaoTest.getJdbcProtocolFor(connection.getMetaData().getURL()));
        }
        finally {
            if (connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {}
            }
        }
    }

    protected static boolean isDatabase(DatabaseType dbType) {
        Optional<String> maybeProtocol = Optional.ofNullable(AbstractAoDaoTest.getJdbcProtocol());
        if (!maybeProtocol.isPresent()) {
            return false;
        }
        String protocol = maybeProtocol.get();
        switch (dbType) {
            case H2: {
                return protocol.startsWith("jdbc:h2");
            }
            case HSQL: {
                return protocol.startsWith("jdbc:hsqldb");
            }
            case MYSQL: {
                return protocol.startsWith("jdbc:mysql");
            }
            case MS_SQL: {
                return protocol.startsWith("jdbc:sqlserver");
            }
            case ORACLE: {
                return protocol.startsWith("jdbc:oracle:thin");
            }
            case POSTGRESQL: {
                return protocol.startsWith("jdbc:postgresql");
            }
        }
        throw new IllegalArgumentException("Unable to identify databases of type " + dbType);
    }

    private static List<String> checkAnnotations(Class<? extends RawEntity<?>> entityClass) {
        Objects.requireNonNull(entityClass, "entityClass");
        ArrayList<String> invalidAnnotations = new ArrayList<String>();
        for (Method method : entityClass.getMethods()) {
            PrimaryKey primaryKey = method.getAnnotation(PrimaryKey.class);
            boolean indexed = method.isAnnotationPresent(Indexed.class);
            boolean unique = method.isAnnotationPresent(Unique.class);
            if (primaryKey != null) {
                String name;
                String string = name = primaryKey.value().trim().isEmpty() ? method.getName() : "\"" + primaryKey.value() + "\" (" + method.getName() + ")";
                if (indexed) {
                    invalidAnnotations.add("@PrimaryKey " + name + " is inherently @Indexed");
                }
                if (!unique) continue;
                invalidAnnotations.add("@PrimaryKey " + name + " is inherently @Unique");
                continue;
            }
            if (!indexed || !unique) continue;
            Accessor accessor = method.getAnnotation(Accessor.class);
            String name = accessor == null ? method.getName() : "\"" + accessor.value() + "\" (" + method.getName() + ")";
            invalidAnnotations.add("@Unique column " + name + " is inherently @Indexed");
        }
        return invalidAnnotations;
    }

    private static String getJdbcProtocol() {
        return AbstractAoDaoTest.getJdbcProtocolFor(AbstractAoDaoTest.getJdbcUrl());
    }

    private static String getJdbcProtocolFor(String url) {
        if (url.startsWith("jdbc:jtds:sqlserver")) {
            return "jdbc:sqlserver";
        }
        Matcher matcher = JDBC_PATTERN.matcher(url);
        return matcher.find() ? matcher.group(1) : null;
    }

    private static String getJdbcUrl() {
        return System.getProperty("jdbc.url", "jdbc:h2:mem:ao");
    }

    private static String toBulletedList(List<String> messages) {
        return messages.stream().collect(Collectors.joining("\n- ", "\n- ", ""));
    }
}

