/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.rule;

import com.atlassian.bitbucket.annotation.FixedCurrentTime;
import org.joda.time.DateTimeUtils;
import org.junit.rules.ExternalResource;
import org.junit.runner.Description;
import org.junit.runners.model.Statement;

public class FixedCurrentTimeRule
extends ExternalResource {
    private final long fixedCurrentTime = System.currentTimeMillis();

    public Statement apply(final Statement base, final Description description) {
        return new Statement(){

            public void evaluate() throws Throwable {
                boolean needsFixedTime;
                boolean bl = needsFixedTime = description.getAnnotation(FixedCurrentTime.class) != null;
                if (needsFixedTime) {
                    DateTimeUtils.setCurrentMillisFixed((long)FixedCurrentTimeRule.this.fixedCurrentTime);
                }
                try {
                    base.evaluate();
                }
                finally {
                    if (needsFixedTime) {
                        DateTimeUtils.setCurrentMillisSystem();
                    }
                }
            }
        };
    }
}

