/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.hamcrest.Description;
import org.hamcrest.Factory;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public class TimeMatchers {
    @Factory
    public static Matcher<Date> closeTo(final Date ref, final int plusOrMinus, final TimeUnit unit) {
        return new TypeSafeMatcher<Date>(){

            public boolean matchesSafely(Date date) {
                return Math.abs(ref.getTime() - date.getTime()) < TimeUnit.MILLISECONDS.convert(plusOrMinus, unit);
            }

            public void describeTo(Description description) {
                description.appendText("a date around ").appendValue((Object)ref).appendText(" plus or minus ").appendValue((Object)plusOrMinus).appendText(" ").appendText(unit.name().toLowerCase());
            }
        };
    }
}

