/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.bitbucket.util.Page;
import com.google.common.base.Preconditions;
import javax.annotation.Nonnull;
import org.hamcrest.Description;
import org.hamcrest.FeatureMatcher;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class PageMatchers {
    private PageMatchers() {
        throw new UnsupportedOperationException(PageMatchers.class.getName() + " should not be instantiated");
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> hasSize(int expectedSize) {
        return PageMatchers.hasSizeThat((Matcher<Integer>)Matchers.is((Object)expectedSize));
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> hasSizeThat(@Nonnull Matcher<Integer> sizeMatcher) {
        Preconditions.checkNotNull(sizeMatcher, (Object)"sizeMatcher");
        return new FeatureMatcher<Page<? extends T>, Integer>(sizeMatcher, "size that", "size"){

            protected Integer featureValueOf(@Nonnull Page<? extends T> actual) {
                return actual.getSize();
            }
        };
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> hasStart(int expectedStart) {
        return PageMatchers.hasStartThat((Matcher<Integer>)Matchers.is((Object)expectedStart));
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> hasStartThat(@Nonnull Matcher<Integer> startMatcher) {
        Preconditions.checkNotNull(startMatcher, (Object)"startMatcher");
        return new FeatureMatcher<Page<? extends T>, Integer>(startMatcher, "start that", "start"){

            protected Integer featureValueOf(@Nonnull Page<? extends T> actual) {
                return actual.getStart();
            }
        };
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> isEmptyPage() {
        return PageMatchers.hasSize(0);
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> isLastPage() {
        return new TypeSafeDiagnosingMatcher<Page<? extends T>>(){

            protected boolean matchesSafely(Page<? extends T> item, Description mismatchDescription) {
                if (!item.getIsLastPage()) {
                    mismatchDescription.appendText("not last");
                }
                return item.getIsLastPage();
            }

            public void describeTo(Description description) {
                description.appendText("Last page with results");
            }
        };
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<? extends T>> isLastPageOf(Matcher<? super T> ... expectedValues) {
        return Matchers.allOf(PageMatchers.isLastPage(), PageMatchers.isPageOf(expectedValues));
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<? extends T>> isLastPageOf(T ... expectedValues) {
        return Matchers.allOf(PageMatchers.isLastPage(), PageMatchers.isPageOf(expectedValues));
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<? extends T>> isPageOf(Matcher<? super T> ... expectedValues) {
        return Matchers.allOf(PageMatchers.hasSize(expectedValues.length), PageMatchers.isPageOf(Matchers.contains(expectedValues)));
    }

    @Nonnull
    @SafeVarargs
    public static <T> Matcher<Page<? extends T>> isPageOf(T ... expectedValues) {
        return Matchers.allOf(PageMatchers.hasSize(expectedValues.length), PageMatchers.isPageOf(Matchers.contains((Object[])expectedValues)));
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> isPageOf(@Nonnull Matcher<? super Iterable<? extends T>> valuesMatcher) {
        Preconditions.checkNotNull(valuesMatcher, (Object)"valuesMatcher");
        return new FeatureMatcher<Page<? extends T>, Iterable<? extends T>>(valuesMatcher, "values that", "values"){

            protected Iterable<? extends T> featureValueOf(@Nonnull Page<? extends T> actual) {
                return actual.getValues();
            }
        };
    }

    @Nonnull
    public static <T> Matcher<Page<? extends T>> isPageWithSize(int expectedSize) {
        return PageMatchers.hasSize(expectedSize);
    }
}

