/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import java.util.Optional;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public abstract class OptionalMatcher<T>
extends TypeSafeDiagnosingMatcher<Optional<T>> {
    public static <T> OptionalMatcher<T> empty() {
        return new EmptyMatcher();
    }

    public static <T> OptionalMatcher<T> empty(Class<? extends T> ignored) {
        return new EmptyMatcher();
    }

    public static <T> OptionalMatcher<T> some(Matcher<? super T> matcher) {
        return new SomeMatcher(matcher);
    }

    public static <T> OptionalMatcher<T> some(T value) {
        return new SomeMatcher(Matchers.equalTo(value));
    }

    public static <T> OptionalMatcher<T> fromOptional(Optional<T> option) {
        return option.map(OptionalMatcher::some).orElseGet(OptionalMatcher::empty);
    }

    private static class SomeMatcher<T>
    extends OptionalMatcher<T> {
        private final Matcher<? super T> matcher;

        private SomeMatcher(Matcher<? super T> matcher) {
            this.matcher = matcher;
        }

        protected boolean matchesSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                if (this.matcher.matches(item.get())) {
                    return true;
                }
                mismatchDescription.appendText("some(");
                this.matcher.describeMismatch(item.get(), mismatchDescription);
                mismatchDescription.appendText(")");
                return false;
            }
            mismatchDescription.appendValue(item);
            return false;
        }

        public void describeTo(Description description) {
            description.appendText("some(").appendDescriptionOf(this.matcher).appendText(")");
        }
    }

    private static class EmptyMatcher<T>
    extends OptionalMatcher<T> {
        private EmptyMatcher() {
        }

        protected boolean matchesSafely(Optional<T> item, Description mismatchDescription) {
            if (item.isPresent()) {
                mismatchDescription.appendValue(item);
                return false;
            }
            return true;
        }

        public void describeTo(Description description) {
            description.appendValue(Optional.empty());
        }
    }
}

