/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.nav;

import com.atlassian.bitbucket.nav.NavBuilder;
import com.google.common.base.Joiner;
import com.google.common.collect.ImmutableList;
import org.mockito.Mockito;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class DummyNavBuilder {
    public static NavBuilder create() {
        return (NavBuilder)Mockito.mock(NavBuilder.class, (Answer)new RecordingAnswer(ImmutableList.of()));
    }

    private static class RecordingAnswer
    implements Answer<Object> {
        private final ImmutableList<String> calls;

        private RecordingAnswer(ImmutableList<String> calls) {
            this.calls = calls;
        }

        public Object answer(InvocationOnMock invocation) throws Throwable {
            Class<?> returnType = invocation.getMethod().getReturnType();
            String call = this.formatCall(invocation);
            ImmutableList newCalls = ImmutableList.builder().addAll(this.calls).add((Object)call).build();
            if (returnType == String.class) {
                return Joiner.on((String)".").join((Iterable)newCalls);
            }
            return Mockito.mock(returnType, (Answer)new RecordingAnswer((ImmutableList<String>)newCalls));
        }

        private String formatCall(InvocationOnMock invocation) {
            String methodName = invocation.getMethod().getName();
            Object[] args = invocation.getArguments();
            if (args == null || args.length == 0) {
                return methodName + "()";
            }
            return methodName + "(" + Joiner.on((String)", ").useForNull("null").join(args) + ")";
        }
    }
}

