/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.mockito;

import com.atlassian.bitbucket.mockito.MockitoUtils;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageUtils;
import com.google.common.base.Preconditions;
import java.util.Arrays;
import java.util.Collections;
import javax.annotation.Nonnull;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class PageAnswer<E>
implements Answer<Page<E>> {
    private final Iterable<E> answer;
    private final boolean isLast;

    private PageAnswer(Iterable<E> answer, boolean isLastPage) {
        this.answer = (Iterable)Preconditions.checkNotNull(answer, (Object)"answer");
        this.isLast = isLastPage;
    }

    @Nonnull
    public static <F> PageAnswer<F> withPageOf(@Nonnull Iterable<F> elements) {
        return new PageAnswer<F>(elements, false);
    }

    @Nonnull
    @SafeVarargs
    public static <F> PageAnswer<F> withPageOf(F ... elements) {
        return PageAnswer.withPageOf(Arrays.asList(elements));
    }

    public static <F> PageAnswer<F> withLastPageOf(@Nonnull Iterable<F> elements) {
        return new PageAnswer<F>(elements, true);
    }

    @Nonnull
    @SafeVarargs
    public static <F> PageAnswer<F> withLastPageOf(F ... elements) {
        return new PageAnswer<F>(Arrays.asList(elements), true);
    }

    @Nonnull
    public static <F> PageAnswer<F> withEmptyPageOf(@Nonnull Class<F> elementType) {
        Preconditions.checkNotNull(elementType, (Object)"elementType");
        return new PageAnswer(Collections.emptyList(), true);
    }

    @Nonnull
    public Page<E> answer(InvocationOnMock invocation) throws Throwable {
        return PageUtils.createPage(this.answer, (boolean)this.isLast, (PageRequest)MockitoUtils.findPageRequest(invocation));
    }
}

