/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.google.common.collect.Sets;
import java.util.HashMap;
import java.util.Map;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.Matchers;
import org.hamcrest.SelfDescribing;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class MapMatcher<K, V>
extends TypeSafeDiagnosingMatcher<Map<K, V>> {
    private Map<K, Matcher<?>> matchers = new HashMap();

    public MapMatcher<K, V> hasEntry(K key, Matcher<?> valueMatcher) {
        this.matchers.put(key, valueMatcher);
        return this;
    }

    public <T extends V> MapMatcher<K, V> hasEntry(K key, T value) {
        return this.hasEntry(key, (T)Matchers.equalTo(value));
    }

    public MapMatcher<K, V> hasKey(K key) {
        return this.hasEntry(key, (Object)Matchers.anything());
    }

    protected boolean matchesSafely(Map<K, V> item, Description mismatchDescription) {
        if (!item.keySet().equals(this.matchers.keySet())) {
            Sets.SetView extraItems = Sets.difference(item.keySet(), this.matchers.keySet());
            Sets.SetView notFound = Sets.difference(this.matchers.keySet(), item.keySet());
            if (extraItems.isEmpty()) {
                mismatchDescription.appendText(String.format("Expected keys %s not found.", notFound));
            } else {
                mismatchDescription.appendText(String.format("Extra keys %s found.", extraItems));
            }
            return false;
        }
        for (Map.Entry<K, Matcher<?>> matcherEntry : this.matchers.entrySet()) {
            K key = matcherEntry.getKey();
            V actualValue = item.get(key);
            Matcher<?> expectedMatcher = matcherEntry.getValue();
            if (expectedMatcher.matches(actualValue)) continue;
            mismatchDescription.appendText(String.format("Entry key %s expected ", key)).appendDescriptionOf(expectedMatcher).appendText(" but was ");
            expectedMatcher.describeMismatch(actualValue, mismatchDescription);
            return false;
        }
        return true;
    }

    public void describeTo(Description description) {
        description.appendText("{");
        boolean first = true;
        for (Map.Entry<K, Matcher<?>> entry : this.matchers.entrySet()) {
            if (!first) {
                description.appendText(", ");
            }
            description.appendText(entry.getKey().toString());
            description.appendText(": ");
            description.appendDescriptionOf((SelfDescribing)entry.getValue());
            first = false;
        }
        description.appendText("}");
    }
}

