/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.stash.internal.user.InternalNormalUser;
import java.time.Instant;
import java.time.ZoneId;
import java.util.Date;
import java.util.Locale;
import java.util.Objects;
import org.hamcrest.Description;
import org.hamcrest.TypeSafeDiagnosingMatcher;

public class InternalNormalUserMatcher
extends TypeSafeDiagnosingMatcher<InternalNormalUser> {
    private Instant deletedTime;
    private Locale locale;
    private String name;
    private String slug;
    private ZoneId timezone;
    private User backingUser;

    public InternalNormalUserMatcher() {
    }

    public InternalNormalUserMatcher(InternalNormalUser user) {
        this.name = user.getName();
        this.slug = user.getSlug();
        this.timezone = user.getTimeZone();
        this.locale = user.getLocale();
        this.deletedTime = user.getDeletedDate() == null ? null : user.getDeletedDate().toInstant();
        this.backingUser = user.getBackingCrowdUser();
    }

    public InternalNormalUserMatcher backingUser(User value) {
        this.backingUser = value;
        return this;
    }

    public InternalNormalUserMatcher locale(Locale value) {
        this.locale = value;
        return this;
    }

    public InternalNormalUserMatcher name(String value) {
        this.name = value;
        return this;
    }

    public InternalNormalUserMatcher slug(String value) {
        this.slug = value;
        return this;
    }

    public InternalNormalUserMatcher timeZone(ZoneId value) {
        this.timezone = value;
        return this;
    }

    public InternalNormalUserMatcher deletedTime(Instant value) {
        this.deletedTime = value;
        return this;
    }

    public InternalNormalUserMatcher deletedTime(Date value) {
        this.deletedTime = value == null ? null : value.toInstant();
        return this;
    }

    protected boolean matchesSafely(InternalNormalUser item, Description mismatchDescription) {
        if (Objects.equals(item.getName(), this.name) && Objects.equals(item.getLocale(), this.locale) && Objects.equals(item.getSlug(), this.slug) && Objects.equals(item.getTimeZone(), this.timezone) && Objects.equals(item.getBackingCrowdUser(), this.backingUser) && Objects.equals(this.toInstant(item.getDeletedDate()), this.deletedTime)) {
            return true;
        }
        long deleted = 0L;
        if (item.getDeletedDate() != null) {
            deleted = item.getDeletedDate().getTime();
        }
        mismatchDescription.appendValue((Object)String.format("User(%s[%s], locale=%s, tz=%s, deletedTime=%d, backingUser=%s)", item.getName(), item.getSlug(), item.getLocale(), item.getTimeZone(), deleted, item.getBackingCrowdUser()));
        return false;
    }

    public void describeTo(Description description) {
        description.appendValue((Object)this.toString());
    }

    public String toString() {
        long deleted = 0L;
        if (this.deletedTime != null) {
            deleted = this.deletedTime.toEpochMilli();
        }
        return String.format("User(%s[%s], locale=%s, tz=%s, deletedTime=%d, backingUser=%s)", this.name, this.slug, this.locale, this.timezone, deleted, this.backingUser);
    }

    private Instant toInstant(Date date) {
        return date == null ? null : date.toInstant();
    }
}

