/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.hamcrest;

import com.google.common.base.Throwables;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.hamcrest.TypeSafeMatcher;

public final class ExceptionMatchers {
    private ExceptionMatchers() {
        throw new UnsupportedOperationException("Attempt to instantiate utility class");
    }

    public static Matcher<Throwable> hasRootCause(final Class<? extends Throwable> clazz) {
        return new TypeSafeMatcher<Throwable>(){

            public boolean matchesSafely(Throwable throwable) {
                return Throwables.getRootCause((Throwable)throwable).getClass() == clazz;
            }

            public void describeTo(Description description) {
                description.appendText("An exception with the root cause " + clazz);
            }
        };
    }

    public static Matcher<Throwable> messageContains(final String m) {
        return new TypeSafeMatcher<Throwable>(){

            public boolean matchesSafely(Throwable throwable) {
                return throwable.getMessage().contains(m);
            }

            public void describeTo(Description description) {
                description.appendText("An exception with its message containing \"" + m + "\"");
            }
        };
    }
}

