/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.servlet;

import com.atlassian.bitbucket.ssh.util.KeyUtils;
import java.util.LinkedHashMap;

class SshKeyForm
extends LinkedHashMap<String, Object> {
    static final String KEY_LABEL = "label";
    static final String KEY_READ_ONLY = "readOnly";
    static final String KEY_TEXT = "text";

    public SshKeyForm(String keyText, boolean readOnly) {
        if (keyText != null) {
            this.put(KEY_TEXT, keyText);
            String label = KeyUtils.getKeyComment(keyText);
            if (label != null) {
                this.put(KEY_LABEL, label);
            }
        }
        this.put(KEY_READ_ONLY, readOnly);
    }

    public String getText() {
        return (String)this.get(KEY_TEXT);
    }

    public String getLabel() {
        return (String)this.get(KEY_LABEL);
    }

    public boolean isReadOnly() {
        return (Boolean)this.get(KEY_READ_ONLY);
    }
}

