/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.server;

import com.atlassian.bitbucket.internal.ssh.server.ForbiddingFileSystemFactory;
import com.atlassian.bitbucket.internal.ssh.server.HostKeyPairProvider;
import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryFilter;
import com.atlassian.bitbucket.internal.ssh.server.NamedFactoryType;
import com.atlassian.bitbucket.internal.ssh.server.SelfClosingChannelSessionFactory;
import com.atlassian.bitbucket.internal.ssh.server.SshServerState;
import com.atlassian.bitbucket.internal.ssh.server.SshServerStatus;
import com.atlassian.bitbucket.internal.ssh.service.SshConfigurationRefreshEvent;
import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.bitbucket.ssh.SshConfiguration;
import com.atlassian.bitbucket.ssh.SshConfigurationService;
import com.atlassian.bitbucket.ssh.event.SshConfigurationChangedEvent;
import com.atlassian.event.api.EventListener;
import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.util.concurrent.ThreadFactories;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nonnull;
import org.apache.sshd.SshBuilder;
import org.apache.sshd.common.Channel;
import org.apache.sshd.common.NamedFactory;
import org.apache.sshd.common.io.mina.MinaServiceFactoryFactory;
import org.apache.sshd.common.util.SecurityUtils;
import org.apache.sshd.server.CommandFactory;
import org.apache.sshd.server.PublickeyAuthenticator;
import org.apache.sshd.server.ServerFactoryManager;
import org.apache.sshd.server.global.KeepAliveHandler;
import org.apache.sshd.server.global.NoMoreSessionsHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.core.Ordered;

public class SshServer
implements DisposableBean,
LifecycleAware,
Ordered {
    private static final Logger log = LoggerFactory.getLogger(SshServer.class);
    private static final long DEFAULT_IDLE_TIMEOUT = TimeUnit.HOURS.toSeconds(2L);
    private static final String PROP_IDLE_TIMEOUT = "plugin.ssh.command.timeout.idle";
    private static final String PROP_SSH_NIO_WORKERS = "plugin.ssh.nio.workers";
    private final long idleTimeout;
    private final Object lock;
    private final org.apache.sshd.SshServer sshServer;
    private final SshConfigurationService sshConfigurationService;
    private volatile SshServerStatus status;

    public SshServer(PublickeyAuthenticator authenticator, CommandFactory commandFactory, SshConfigurationService configurationService, HostKeyPairProvider keyPairProvider, ApplicationPropertiesService propertiesService, NamedFactoryFilter factoryFilter) throws IOException {
        Preconditions.checkState((boolean)SecurityUtils.isBouncyCastleRegistered(), (Object)"BouncyCastle is not registered as expected");
        this.sshConfigurationService = configurationService;
        this.idleTimeout = TimeUnit.SECONDS.toMillis(propertiesService.getPluginProperty(PROP_IDLE_TIMEOUT, DEFAULT_IDLE_TIMEOUT));
        this.lock = new Object();
        this.sshServer = this.init(authenticator, commandFactory, keyPairProvider, propertiesService, factoryFilter);
        this.status = SshServerStatus.forState(SshServerState.STOPPED);
    }

    public void destroy() {
        this.stopServer();
    }

    public int getOrder() {
        return 10;
    }

    public SshServerStatus getStatus() {
        return this.status;
    }

    public boolean isRunning() {
        return this.status.getState() == SshServerState.RUNNING;
    }

    @EventListener
    public void onConfigurationChange(SshConfigurationChangedEvent event) {
        this.synchronizeStateFrom(event.getNewConfiguration());
    }

    @EventListener
    public void onConfigurationRefresh(SshConfigurationRefreshEvent event) {
        this.synchronizeStateFrom(this.sshConfigurationService.getConfiguration());
    }

    public void onStart() {
        SshConfiguration sshConfiguration = this.sshConfigurationService.getConfiguration();
        if (sshConfiguration.isEnabled()) {
            this.startServer(sshConfiguration.getPort());
        }
    }

    public void onStop() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void startServer(int port) {
        if (this.status.getState() != SshServerState.RUNNING) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status.getState() != SshServerState.RUNNING) {
                    this.startServerInternal(port);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopServer() {
        if (this.status.getState() != SshServerState.STOPPED) {
            Object object = this.lock;
            synchronized (object) {
                if (this.status.getState() != SshServerState.STOPPED) {
                    this.stopServerInternal();
                }
            }
        }
    }

    public Optional<Integer> getPort() {
        return this.status.getState() == SshServerState.RUNNING ? Optional.of(this.sshServer.getPort()) : Optional.empty();
    }

    @Nonnull
    private static ScheduledExecutorService createScheduledExecutor(String name) {
        return Executors.newSingleThreadScheduledExecutor(ThreadFactories.namedThreadFactory((String)name, (ThreadFactories.Type)ThreadFactories.Type.DAEMON));
    }

    private org.apache.sshd.SshServer init(PublickeyAuthenticator authenticator, CommandFactory scmCommandFactory, HostKeyPairProvider keyPairProvider, ApplicationPropertiesService propertiesService, NamedFactoryFilter factoryFilter) {
        org.apache.sshd.SshServer server = (org.apache.sshd.SshServer)((SshBuilder.ServerBuilder)((SshBuilder.ServerBuilder)SshBuilder.server().fileSystemFactory(new ForbiddingFileSystemFactory())).globalRequestHandlers(Arrays.asList(new KeepAliveHandler(), new NoMoreSessionsHandler()))).build();
        server.setChannelFactories((List<NamedFactory<Channel>>)ImmutableList.of((Object)new SelfClosingChannelSessionFactory()));
        server.setCipherFactories(factoryFilter.filter(server.getCipherFactories(), NamedFactoryType.CIPHER));
        server.setCommandFactory(scmCommandFactory);
        server.setGSSAuthenticator(null);
        server.setIoServiceFactoryFactory(new MinaServiceFactoryFactory());
        server.setKeyExchangeFactories(factoryFilter.filter(server.getKeyExchangeFactories(), NamedFactoryType.KEY_EXCHANGE));
        server.setKeyPairProvider(keyPairProvider);
        server.setMacFactories(factoryFilter.filter(server.getMacFactories(), NamedFactoryType.MAC));
        server.setPasswordAuthenticator(null);
        server.setProperties((Map<String, String>)ImmutableMap.builder().put((Object)"idle-timeout", (Object)Long.toString(this.idleTimeout)).put((Object)"nio-workers", (Object)Integer.toString(propertiesService.getPluginProperty(PROP_SSH_NIO_WORKERS, ServerFactoryManager.DEFAULT_NIO_WORKERS))).build());
        server.setPublickeyAuthenticator(authenticator);
        server.setScheduledExecutorService(SshServer.createScheduledExecutor("ssh-server"), true);
        server.setShellFactory(null);
        server.setTcpipForwardingFilter(null);
        return server;
    }

    private void startServerInternal(int port) {
        try {
            log.info("Starting SSH server on port {}...", (Object)port);
            this.sshServer.setPort(port);
            this.sshServer.start();
            this.status = SshServerStatus.forState(SshServerState.RUNNING);
            log.info("Started SSH server successfully.");
        }
        catch (IOException e) {
            this.status = SshServerStatus.forException(e);
            log.error("SSH server failed to start", (Throwable)e);
        }
    }

    private void stopServerInternal() {
        if (this.isRunning()) {
            try {
                log.info("Stopping SSH server...");
                this.sshServer.stop(true);
                log.info("Stopped SSH server successfully.");
            }
            catch (InterruptedException e) {
                log.warn("Interrupted while waiting for the SshServer to shutdown; some sessions may still be active.");
            }
        }
        this.status = SshServerStatus.forState(SshServerState.STOPPED);
    }

    private void synchronizeStateFrom(SshConfiguration configuration) {
        if (this.isRunning()) {
            if (!configuration.isEnabled()) {
                this.stopServer();
            } else if (this.sshServer.getPort() != configuration.getPort()) {
                this.stopServer();
                this.startServer(configuration.getPort());
            }
        } else if (configuration.isEnabled()) {
            this.startServer(configuration.getPort());
        }
    }
}

