/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.ssh.json;

import com.atlassian.bitbucket.internal.key.ssh.rest.RestSshAccessKey;
import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.json.JsonRenderer;
import com.atlassian.bitbucket.request.RequestManager;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.enrich.AvatarEnricher;
import com.atlassian.bitbucket.rest.enrich.LinkEnricher;
import com.atlassian.bitbucket.rest.util.RestUtils;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import com.atlassian.bitbucket.ssh.SshKey;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.codehaus.jackson.JsonFactory;
import org.codehaus.jackson.JsonGenerator;
import org.codehaus.jackson.map.ObjectMapper;

public class SshJsonRenderer
implements JsonRenderer {
    private final AvatarEnricher avatarEnricher;
    private final LinkEnricher linkEnricher;
    private final JsonFactory jsonFactory;
    private final RequestManager requestManager;

    public SshJsonRenderer(AvatarEnricher avatarEnricher, LinkEnricher linkEnricher, RequestManager requestManager) {
        this.avatarEnricher = avatarEnricher;
        this.linkEnricher = linkEnricher;
        this.requestManager = requestManager;
        this.jsonFactory = new ObjectMapper().getJsonFactory();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public String render(@Nullable Object object, @Nonnull Map<String, Object> options) {
        RestMapEntity restSurrogate = null;
        if (object instanceof SshKey) {
            restSurrogate = new RestSshKey((SshKey)object);
        } else if (object instanceof SshAccessKey) {
            restSurrogate = new RestSshAccessKey((SshAccessKey)object);
        }
        if (restSurrogate == null) return null;
        this.avatarEnricher.enrich((Object)restSurrogate, RestUtils.makeAvatarRequest((RequestManager)this.requestManager, options));
        this.linkEnricher.enrich((Object)restSurrogate);
        StringWriter writer = new StringWriter();
        try (JsonGenerator generator = this.jsonFactory.createJsonGenerator((Writer)writer);){
            generator.writeObject((Object)restSurrogate);
            generator.flush();
            String string = writer.toString();
            return string;
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }
}

