/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.rest;

import com.atlassian.bitbucket.internal.ssh.rest.RestSshKey;
import com.atlassian.bitbucket.permission.Permission;
import com.atlassian.bitbucket.project.Project;
import com.atlassian.bitbucket.repository.Repository;
import com.atlassian.bitbucket.rest.RestMapEntity;
import com.atlassian.bitbucket.rest.project.RestProject;
import com.atlassian.bitbucket.rest.repository.RestRepository;
import com.atlassian.bitbucket.rest.util.RestDocUtils;
import com.atlassian.bitbucket.rest.util.RestPage;
import com.atlassian.bitbucket.ssh.SshAccessKey;
import java.util.function.Function;
import org.codehaus.jackson.map.annotate.JsonSerialize;

@JsonSerialize
public class RestSshAccessKey
extends RestMapEntity {
    private static final String KEY = "key";
    private static final String PROJECT = "project";
    private static final String REPOSITORY = "repository";
    private static final String PERMISSION = "permission";
    public static final Function<SshAccessKey, RestSshAccessKey> REST_TRANSFORM = RestSshAccessKey::new;
    public static final RestSshAccessKey PROJECT_REQUEST_EXAMPLE = new RestSshAccessKey(RestSshKey.EXAMPLE_REQUEST, null, null, Permission.PROJECT_READ);
    public static final RestSshAccessKey PROJECT_RESPONSE_EXAMPLE = new RestSshAccessKey(RestSshKey.EXAMPLE_RESPONSE, RestProject.RESPONSE_EXAMPLE, null, Permission.PROJECT_READ);
    public static final RestSshAccessKey REPOSITORY_REQUEST_EXAMPLE = new RestSshAccessKey(RestSshKey.EXAMPLE_REQUEST, null, null, Permission.REPO_WRITE);
    public static final RestSshAccessKey REPOSITORY_RESPONSE_EXAMPLE = new RestSshAccessKey(RestSshKey.EXAMPLE_REQUEST, null, RestRepository.RESPONSE_EXAMPLE, Permission.REPO_WRITE);
    public static final RestPage<RestSshAccessKey> PAGE_PROJECT_EXAMPLE = RestDocUtils.pageOf((Object[])new RestSshAccessKey[]{PROJECT_RESPONSE_EXAMPLE});
    public static final RestPage<RestSshAccessKey> PAGE_REPOSITORY_EXAMPLE = RestDocUtils.pageOf((Object[])new RestSshAccessKey[]{REPOSITORY_RESPONSE_EXAMPLE});

    public RestSshAccessKey() {
    }

    public RestSshAccessKey(RestSshKey key, RestProject project, RestRepository repository, Permission permission) {
        this.put(KEY, (Object)key);
        if (project != null) {
            this.put(PROJECT, project);
        }
        if (repository != null) {
            this.put(REPOSITORY, repository);
        }
        this.put(PERMISSION, permission);
    }

    public RestSshAccessKey(SshAccessKey accessKey) {
        this.put(KEY, (Object)new RestSshKey(accessKey.getKey()));
        Object resource = accessKey.getResource();
        if (resource instanceof Project) {
            this.put(PROJECT, new RestProject((Project)resource));
        } else {
            this.put(REPOSITORY, new RestRepository((Repository)resource));
        }
        this.put(PERMISSION, accessKey.getPermission().name());
    }

    public RestSshKey getKey() {
        return RestSshKey.valueOf(this.get(KEY));
    }

    public Permission getPermission() {
        if (this.containsKey(PERMISSION)) {
            return Permission.valueOf((String)this.getStringProperty(PERMISSION));
        }
        return null;
    }

    public RestProject getProject() {
        return RestProject.valueOf((Object)this.get(PROJECT));
    }

    public RestRepository getRepository() {
        return RestRepository.valueOf((Object)this.get(REPOSITORY));
    }

    public boolean hasKey() {
        return this.getKey() != null;
    }

    public boolean hasPermission() {
        return this.containsKey(PERMISSION);
    }

    public boolean hasProject() {
        return this.getProject() != null;
    }

    public boolean hasRepository() {
        return this.getRepository() != null;
    }
}

