/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.bitbucket.internal.key.ssh.dao;

import com.atlassian.activeobjects.external.ActiveObjects;
import com.atlassian.bitbucket.ao.AbstractAoDao;
import com.atlassian.bitbucket.internal.key.ssh.dao.AoSshKey;
import com.atlassian.bitbucket.internal.key.ssh.dao.SshKeyDao;
import com.atlassian.bitbucket.ssh.util.KeyUtils;
import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.google.common.base.Predicate;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.security.PublicKey;
import java.util.Arrays;
import java.util.Map;
import javax.annotation.Nonnull;
import net.java.ao.Query;
import net.java.ao.RawEntity;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AoSshKeyDao
extends AbstractAoDao
implements SshKeyDao {
    private static final Logger log = LoggerFactory.getLogger(AoSshKeyDao.class);

    public AoSshKeyDao(ActiveObjects ao) {
        super(ao);
    }

    @Override
    @Nonnull
    public AoSshKey create(ApplicationUser user, @Nonnull String keyText, String label) {
        PublicKey publicKey = KeyUtils.getPublicKey(keyText);
        ImmutableMap.Builder builder = new ImmutableMap.Builder();
        builder.put((Object)"KEY_TEXT", (Object)keyText);
        builder.put((Object)"KEY_MD5", (Object)KeyUtils.computeMD5(publicKey.getEncoded()));
        if (user != null) {
            builder.put((Object)"USER_ID", (Object)user.getId());
        }
        if (label != null) {
            builder.put((Object)"LABEL", (Object)StringUtils.left((String)label, (int)255));
        }
        return (AoSshKey)this.ao.create(AoSshKey.class, (Map)builder.build());
    }

    @Override
    public void delete(@Nonnull AoSshKey key) {
        this.ao.delete(new RawEntity[]{key});
    }

    @Override
    public void deleteAllForUser(int userId) {
        log.debug("Fetching ssh keys for user with id={}", (Object)userId);
        AoSshKey[] keys = (AoSshKey[])this.ao.find(AoSshKey.class, this.newUnorderedQuery("USER_ID = ?", userId));
        log.debug("There are {} ssh keys owned by user {} to delete", (Object)keys.length, (Object)userId);
        for (AoSshKey key : keys) {
            this.ao.delete(new RawEntity[]{key});
            log.debug("Deleted key with id={}", (Object)key.getId());
        }
    }

    @Override
    public boolean existsForAnyUser(@Nonnull PublicKey key) {
        byte[] remoteKey = key.getEncoded();
        String md5 = KeyUtils.computeMD5(remoteKey);
        Query query = this.newUnorderedQuery("KEY_MD5 = ? and USER_ID is not null", md5);
        return Iterables.any(Arrays.asList(this.ao.find(AoSshKey.class, query)), this.keyMatchesPublicKey(remoteKey));
    }

    @Override
    public boolean existsForUser(int userId) {
        return this.ao.count(AoSshKey.class, this.newUnorderedQuery("USER_ID = ?", userId)) > 0;
    }

    @Override
    @Nonnull
    public Page<AoSshKey> findByUser(int userId, @Nonnull PageRequest pageRequest) {
        return this.pageQuery(AoSshKey.class, this.newQuery("USER_ID = ?", userId), pageRequest);
    }

    @Override
    public AoSshKey getById(int id) {
        return (AoSshKey)this.ao.get(AoSshKey.class, (Object)id);
    }

    @Override
    public AoSshKey getByPublicKey(@Nonnull PublicKey key) {
        byte[] remoteKey = key.getEncoded();
        String md5 = KeyUtils.computeMD5(remoteKey);
        return this.findMatchingKey(remoteKey, this.newUnorderedQuery("KEY_MD5 = ?", md5));
    }

    @Override
    public AoSshKey getByUserPublicKey(@Nonnull PublicKey key) {
        byte[] remoteKey = key.getEncoded();
        String md5 = KeyUtils.computeMD5(remoteKey);
        return this.findMatchingKey(remoteKey, this.newUnorderedQuery("KEY_MD5 = ? and USER_ID is not null", md5));
    }

    private AoSshKey findMatchingKey(byte[] remoteKey, Query query) {
        return (AoSshKey)Iterables.find(Arrays.asList(this.ao.find(AoSshKey.class, query)), this.keyMatchesPublicKey(remoteKey), null);
    }

    private Predicate<AoSshKey> keyMatchesPublicKey(final byte[] remoteKey) {
        return new Predicate<AoSshKey>(){

            public boolean apply(AoSshKey key) {
                return Arrays.equals(remoteKey, key.toPublicKey().getEncoded());
            }
        };
    }

    private Query newQuery(String clause, Object ... params) {
        return Query.select().from(AoSshKey.class).where(clause, params).order("ENTITY_ID");
    }

    private Query newUnorderedQuery(String clause, Object ... params) {
        return Query.select().from(AoSshKey.class).where(clause, params);
    }
}

