package com.atlassian.bitbucket.util;

import java.util.Comparator;

/**
 * An interface for objects that have a weight associated with them used for sorting.
 * Lower weights are first (on the top), heavier weights come last (on the bottom).
 */
public interface Weighted {

    /**
     * Note that this comparator only considers weight.  If you use this in a SortedSet implementation,
     * you will lose elements with the same weight because it reports they are equal.
     *
     * This is intended for use with Collections.sort()
     */
    Comparator<Weighted> COMPARABLE = new Comparator<Weighted>() {
        @Override
        public int compare(Weighted w1, Weighted w2) {
            if (w1.getWeight() < w2.getWeight()) {
                return -1;
            } else if (w1.getWeight() > w2.getWeight()) {
                return 1;
            } else {
                return 0;
            }
        }
    };

    /**
     * @return the weight of this item (lower weight first, higher weight lower)
     */
    int getWeight();

}
