package com.atlassian.bitbucket.user;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.StateAware;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * Module Descriptor for providing {@link UserErasureHandler user erasure handlers}.
 * <p>
 * Usage example:
 * <pre><code>
 * &lt;user-erasure-handler key="my-user-erasure-handler" class="com.example.bitbucket.MyUserErasureHandler" weight="120" /&gt;
 * </code></pre>
 *
 * @see UserAdminService#eraseUser(String)
 * @see UserErasureHandler
 * @since 5.16
 */
public class UserErasureModuleDescriptor extends BaseWeightedModuleDescriptor<UserErasureHandler> {

    public static final String XML_ELEMENT_NAME = "user-erasure-handler";

    private volatile UserErasureHandler module;

    public UserErasureModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 100);
    }

    @Override
    public void disabled() {
        if (module instanceof StateAware) {
            ((StateAware) module).disabled();
        }
        module = null;

        super.disabled();
    }

    @Override
    public UserErasureHandler getModule() {
        if (module == null) {
            module = moduleFactory.createModule(moduleClassName, this);
        }
        return module;
    }
}
