package com.atlassian.bitbucket.user;

import javax.annotation.Nonnull;

/**
 * User Anonymization SPI
 * <p>
 * Implement this interface to be notified whenever an admin requests for a user to be anonymized in the system.
 * <p>
 * To make use of an implementation, declare a {@link UserErasureModuleDescriptor &lt;user-erasure-handler&gt;} module
 * in your {@code atlassian-plugin.xml}.
 *
 * @see UserAdminService#eraseUser(String)
 * @see UserErasureModuleDescriptor
 * @since 5.16
 */
public interface UserErasureHandler {

    void eraseUser(@Nonnull UserErasureRequest request);
}
