package com.atlassian.bitbucket.ui;

import javax.annotation.Nonnull;

/**
 * Used by {@link ContextualFormFragment} to report field validation errors.
 */
public interface ValidationErrors {

    /**
     * Add an error message to a specific field. You can add multiple error messages per field.
     * 
     * @param fieldName the name attribute value of the field
     * @param errorMessage the error message. This should be an internationalised String resolved using SAL's
     *                     I18nResolver.
     */
    void addFieldError(@Nonnull String fieldName, @Nonnull String errorMessage);

    /**
     * Add a general error message that will be rendered at the top of the form.
     *
     * @param errorMessage the error message. This should be an internationalised String resolved using SAL's
     *                     I18nResolver.
     */
    void addFormError(@Nonnull String errorMessage);

}