package com.atlassian.bitbucket.ui;

import javax.annotation.Nonnull;
import java.util.Map;

/**
 * Factory for {@link PluginFormFragments}. Use to get a {@link PluginFormFragments} for a particular form.
 *
 * @see PluginFormFragments
 */
public interface PluginFormFragmentsFactory {

    /**
     * Checks if any form fragment is associated with a form key.
     *
     * @param formKey the key of the form to check for associated form fragments. For example
     *                "bitbucket.internal.page.admin.serversettings.serversettings" for the Server Settings administration page.
     * @return {@code true} if any form fragment is associated with the key
     */
    boolean existsForKey(@Nonnull String formKey);

    /**
     * Gets the form fragments associated with a form key.
     *
     * @param formKey the key of the form to retrieve {@link ContextualFormFragment}s for. For example
     *                "bitbucket.admin.serversettings" for the Server Settings administration page.
     * @param context map with contextual objects
     * @return {@link PluginFormFragments} collating all {@link ContextualFormFragment}s
     *         registered for the specified key.
     */
    @Nonnull
    PluginFormFragments forKey(@Nonnull String formKey, @Nonnull Map<String, Object> context);
}