package com.atlassian.bitbucket.ui;

import javax.annotation.Nonnull;
import java.util.Collection;
import java.util.Map;

/**
 * Collates a collection of enabled {@link ContextualFormFragment}s plugin modules defined for a particular form.
 *
 * @see PluginFormFragmentsFactory
 */
public interface PluginFormFragments {

    /**
     * @return rendered HTML of all fields supplied by {@link ContextualFormFragment}s defined for this form.
     * @see ContextualFormFragment#doView
     */
    @Nonnull
    String getViewHtml();

    /**
     * Validate all {@link ContextualFormFragment}s defined for this form.
     * 
     * @param requestParams {@link javax.servlet.http.HttpServletRequest#getParameterMap()} of the currently executing
     *                      POST form submission
     * @param errors the {@link ValidationErrors} object to be populated by any registered {@link ContextualFormFragment}s
     * @see ContextualFormFragment#validate
     */
    void validate(@Nonnull Map<String, String[]> requestParams, @Nonnull ValidationErrors errors);

    /**
     * @param requestParams {@link javax.servlet.http.HttpServletRequest#getParameterMap()} of the currently executing
     *                      POST form submission
     * @param fieldErrors a {@link Map} of String field names to sets of String error messages.
     * @return rendered HTML of all fields supplied by {@link ContextualFormFragment}s for this form when a validation error has
     * occurred. 
     * @see ContextualFormFragment#doError
     */
    @Nonnull
    String getErrorHtml(@Nonnull Map<String, String[]> requestParams, @Nonnull Map<String, Collection<String>> fieldErrors);

    /**
     * Execute all of the {@link ContextualFormFragment}s defined for this form.
     *
     * @param requestParams {@link javax.servlet.http.HttpServletRequest#getParameterMap()} of the currently executing
     *                      POST form submission
     * @see ContextualFormFragment#execute
     */
    void execute(@Nonnull Map<String, String[]> requestParams);
}