package com.atlassian.bitbucket.ssh.command;

import com.atlassian.bitbucket.scm.BaseWeightedModuleDescriptor;
import com.atlassian.plugin.module.ModuleFactory;

/**
 * Module descriptor for providing {@link SshCommandFactory} implementations.
 * <p>
 * Usage:
 * <pre><code>
 *     &lt;ssh-command-factory
 *              key="whoSshCommandFactory"
 *              class="com.example.ssh.WhoSshCommandFactory"
 *              weight="100"/&gt;
 * </code></pre>
 * The {@code key} and {@code class} attributes are <b>required</b>. The {@code weight} attribute is <i>optional</i>.
 * <ul>
 *     <li>{@code weight}: Defines the order in which {@link SshCommandFactory} implementations will be
 *     queried. Lower weights are queried earlier and the default weight is 100. The first implementation
 *     that supports a given command will be used</li>
 * </ul>
 */
public class SshCommandFactoryModuleDescriptor extends BaseWeightedModuleDescriptor<SshCommandFactory> {

    public static final String XML_ELEMENT_NAME = "ssh-command-factory";

    public SshCommandFactoryModuleDescriptor(ModuleFactory moduleFactory) {
        super(moduleFactory, 100);
    }

    @Override
    public SshCommandFactory getModule() {
        SshCommandFactory module = moduleFactory.createModule(moduleClassName, this);
        return module;
    }
}
